<?php

namespace AppBundle\Repository;

/**
 * CategoryRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class CategoryRepository extends \Doctrine\ORM\EntityRepository
{
    /**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null)
    {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('category'))
            ->from('AppBundle:Category', 'category');

        return $qb;
    }

    public function findForSearch($query)
    {
        $qb = $this->addActiveQuery();

        $qb->andWhere($qb->expr()->like($qb->expr()->lower('category.name'), ':query'))
          ->setParameter(':query', "%" . strtolower($query) . "%");

        return $qb->getQuery()->getResult();
    }
}
