<?php

namespace AppBundle\Repository;

use Doctrine\ORM\Query\Expr;

/**
 * ClientRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ClientRepository extends \Doctrine\ORM\EntityRepository
{

    /**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null)
    {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('c'))
            ->from('AppBundle:Client', 'c');

        return $qb;
    }

    public function findByCompany($company)
    {
        $qb = $this->addActiveQuery();

        $qb->andWhere("c.company = :company")
            ->setParameter("company", $company);

        return $qb->getQuery()->getResult();
    }

    public function findForApi($mat_colaborador, $group, $cpf)
    {
        // ->andWhere('lower(userStatus.name) != :status_demitido')
        // ->setParameter('status_demitido', "demitido")

        $qb = $this->addActiveQuery();
        $qb->leftJoin("c.userStatus", "userStatus");
        $qb->andWhere('((userStatus.code != 7 and userStatus.code != 71 and userStatus.code != 77) or userStatus.code is null)');
        $qb->setMaxResults(500);

        if (!empty($mat_colaborador)) {
            $qb->andWhere('c.mat_colaborador = :mat_colaborador');
            $qb->setParameter('mat_colaborador', $mat_colaborador);
        }

        // if (!empty($group)) {
        //     $qb->andWhere('c.group = :group');
        //     $qb->setParameter('group', $group);
        // }

        if ($group != null) {
            $arrayIds = array();
            foreach ($group as $key => $value) {
                array_push($arrayIds, $value->getId());
            }

            $qb->andWhere('c.usergroup IN ('.implode(",", $arrayIds).')');
            //  ->setParameter('ids', implode(",", $arrayIds));
        }

        if (!empty($cpf)) {
            $qb->andWhere('c.cpf = :cpf');
            $qb->setParameter('cpf', $cpf);
        }

        return $qb->getQuery()->getResult();
    }

    public function findByNumCadAndNumEmp($mat_colaborador, $num_enterprise)
    {
        $qb = $this->addActiveQuery();

        // if (!empty($mat_colaborador)) {
            $qb->andWhere("c.mat_colaborador = :mat_colaborador");
            $qb->setParameter("mat_colaborador", $mat_colaborador);
        // }

        // if (!empty($num_enterprise)) {
            $qb->andWhere("c.num_enterprise = :num_enterprise");
            $qb->setParameter("num_enterprise", $num_enterprise);
        // }

        $qb->setMaxResults(1);
        $qb->orderBy('c.id', 'DESC');

        $query = $qb->getQuery();

        return $query->getOneOrNullResult();
    }

    public function findByPagination($query = null, $user_group = null, $enabled = null)
    {
        $qb = $this->addActiveQuery();
        $qb->leftJoin('UserBundle:User', 'user', \Doctrine\ORM\Query\Expr\Join::WITH, 'user.id=c.id');
        if ($query!=null || !empty($query)) {
            $qb->andWhere($qb->expr()->like($qb->expr()->lower('c.username'), ':query'))
                ->orWhere($qb->expr()->like($qb->expr()->lower("CONCAT(c.first_name, ' ',c.last_name)"), ':query'))
                ->orWhere($qb->expr()->like($qb->expr()->lower('c.mat_colaborador'), ':query'))
                ->setParameter(':query', "%" . strtolower($query) . "%");
        }
        if($user_group){
            $qb->andWhere("user.usergroup = :user_group")
            ->setParameter("user_group", $user_group);
        }
        if($enabled){
            $qb->andWhere("user.enabled = :enabled")
            ->setParameter("enabled", $enabled);
        }
        $qb->orderBy('c.first_name', 'ASC');

        return $qb->getQuery();
    }

    /**
     * @param array $get
     * @param bool $flag
     * @return array|\Doctrine\ORM\Query
     */
    public function ajaxTable(array $get, $flag = false, $count = false, $enterprises = null)
    {
        /* Indexed column (used for fast and accurate table cardinality) */
        $alias = 'client';
        /* DB table to use */
        $tableObjectName = 'AppBundle:Client';
        /**
         * Set to default
         */
        if (!isset($get['columns']) || empty($get['columns'])) {
            $get['columns'] = array('id');
        }
        $aColumns = array();
        foreach ($get['columns'] as $value) {
            // if (strpos($value, '.') !== false) {
            $aColumns[] = $value;
            // } else {
                // $aColumns[] = $alias .'.'. $value;
            // }
        }

        $cb = $this->getEntityManager()
        ->getRepository($tableObjectName)
        ->createQueryBuilder($alias);
        //->select(str_replace(" , ", " ", implode(", ", $aColumns)));
        if (isset($get['iDisplayStart']) && $get['iDisplayLength'] != '-1' && !$count) {
            $cb->setFirstResult((int)$get['iDisplayStart'])
            ->setMaxResults((int)$get['iDisplayLength']);
        }

        $cb->leftJoin('UserBundle:User', 'user', \Doctrine\ORM\Query\Expr\Join::WITH, 'user.id=client.id');
        $cb->leftJoin("user.sector", "sector");
        $cb->leftJoin("user.jobRole", "jobRole");
        $cb->leftJoin("user.userStatus", "userStatus");
        if ($enterprises != null) {
            $cb->andWhere('client.num_enterprise IN (:ids)')
             ->setParameter('ids', $enterprises);
        }
        /*
         * Ordering
         */
        // if ( isset( $get['iSortCol_0'] ) ){
        //   for ( $i=0 ; $i<intval( $get['iSortingCols'] ) ; $i++ ){
        //     if ( $get[ 'bSortable_'.intval($get['iSortCol_'.$i]) ] == "true" ){
        //       $cb->orderBy($aColumns[ (int)$get['iSortCol_'.$i] ], $get['sSortDir_'.$i]);
        //     }
        //   }
        // }
        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        if (isset($get['sSearch']) && $get['sSearch'] != '') {
            $aLike = array();
            for ($i=0 ; $i<count($aColumns) ; $i++) {
                // if (isset($get['bSearchable_'.$i]) && $get['bSearchable_'.$i] == "true") {
                $aLike[] = $cb->expr()->like($aColumns[$i], '\'%'. $get['sSearch'] .'%\'');
                // }
            }
            // $aLike[] = $cb->expr()->like("", '\'%'. $get['sSearch'] .'%\'');
            if (count($aLike) > 0) {
                $cb->andWhere(new Expr\Orx($aLike));
            } else {
                unset($aLike);
            }
        }
        /*
         * SQL queries
         * Get data to display
         */

        if ($flag) {
            $query = $cb->getQuery();
            return $query;
        } else {
            if ($count) {
                $cb->select("COUNT(client) as totalClients");
                $query = $cb->getQuery();
                return $query->getSingleScalarResult();
            } else {
                $query = $cb->getQuery();
                return $query->getResult();
            }
        }
    }

    /**
     * @return int
     */
    public function getCount($enterprises = null)
    {
        // if($enterprises){
        //     $aResultTotal = $this->getEntityManager()
        //         ->createQuery('SELECT COUNT(a) FROM AppBundle:Client a')
        //         ->andWhere('a.numEmp IN (:ids)')
        //         ->setParameter('ids', $enterprises)
        //         ->setMaxResults(1)
        //         ->getResult();
        // }else{
        //     $aResultTotal = $this->getEntityManager()
        //         ->createQuery('SELECT COUNT(a) FROM AppBundle:Client a')
        //         ->setMaxResults(1)
        //         ->getResult();
        // }
        // return $aResultTotal[0][1];

        $qb = $this->addActiveQuery();
        $qb->select('count(c.id) as totalClients');
        $qb->leftJoin('UserBundle:User', 'user', \Doctrine\ORM\Query\Expr\Join::WITH, 'user.id=c.id');
        if ($enterprises != null) {
            $qb->andWhere('c.num_enterprise IN (:ids)')
             ->setParameter('ids', $enterprises);
        }

        return $qb->getQuery()->getSingleScalarResult();
    }

    public function findForSearch($query)
    {
        $qb = $this->addActiveQuery();

        $qb->andWhere($qb->expr()->like($qb->expr()->lower('c.username'), ':query'))
            ->orWhere($qb->expr()->like($qb->expr()->lower("CONCAT(c.first_name, ' ',c.last_name)"), ':query'))
            ->setParameter(':query', "%" . strtolower($query) . "%");

        return $qb->getQuery()->getResult();
    }

    public function findTotalClients($onlyActive = null)
    {
        $qb = $this->addActiveQuery();
        $qb->select('count(c.id) as totalClients');
        if($onlyActive){
            $qb->leftJoin('UserBundle:User', 'user', \Doctrine\ORM\Query\Expr\Join::WITH, 'user.id=c.id');
            $qb->andWhere("user.enabled = :enabled")
            ->setParameter("enabled", $onlyActive);
        }

        return $qb->getQuery()->getSingleScalarResult();
    }


    public function findBySecretaria()
    {
        $qb = $this->addActiveQuery();

        $qb->andWhere($qb->expr()->like($qb->expr()->lower('c.group'), ':group1') ." or ". $qb->expr()->like($qb->expr()->lower('c.group'), ':group2'))
        ->setParameter(':group1', "%" . strtolower("OUTSYS_PORTALATENDENTE.PERFIL_COMUM") . "%")
        ->setParameter(':group2', "%" . strtolower("CLAUSU.PERFIL_SECRETARIA_MEDICO") . "%");

        return $qb->getQuery()->getResult();
    }

    /**
     * Retorna o total de registros com o slug especificado.
     * @param string $username Username a ser pesquisado.
     * @param boolean $onlyActive Indica se deve contar apenas eventos ativos.
     * @param string $email Email a ser pesquisado
     * @return integer Total de registros.
     */
    public function getClientByCPF($entity, $onlyActive = false)
    {
        $qb = $this->addActiveQuery();

        $qb->andWhere("c.cpf = :cpf")
            ->setParameter("cpf", $entity->getCpf());

        return $this->validateUsersByCPF($qb, $entity);
    }

    /**
     * Complemento do método getClientByCPF
     * @param object $entity
     * @return Boolean
     */
    public function validateUsersByCPF($qb, $entity)
    {
        $flag = true;

        if ($entity->getId() != null) {
            // Buscar lista de ids com username ou email
            $results = $qb->select('c.id')->getQuery()->getScalarResult();
            $ids = array_map('current', $results);

            // Caso a lista tiver mais de 1 elemento, retorne false
            if (count($ids) > 1) {
                $flag = false;
            }
            // Caso a lista conter um elemento
            elseif (count($ids) == 1) {
                //e esse elemento for diferente ao id de cadastro retorne false
                if (!in_array($entity->getId(), $ids)) {
                    $flag = false;
                };
            }
        } else {
            $query = $qb->getQuery();
            if (count($query->getResult()) > 0) {
                $flag = false;
            }
        }

        return $flag;
    }

    public function updateAccessGranted($accessgranted, $user_group){

        $sql = "update user set access_granted = :accessgranted where usergroup_id = :user_group";
        $params = array('accessgranted'=>$accessgranted?'1':'0', 'user_group'=>$user_group);

        $em = $this->getEntityManager();
        $stmt = $em->getConnection()->prepare($sql);
        $stmt->execute($params);
    }
}
