<?php

namespace AppBundle\Repository;

/**
 * CommentCourseRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class CommentCourseRepository extends \Doctrine\ORM\EntityRepository
{
    /**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null)
    {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('commentcourse'))
            ->from('AppBundle:CommentCourse', 'commentcourse');

        return $qb;
    }

    /**
    * Busca todas as matriculas a partir dos dados informados
    * @return array Array de registros.
    */
    public function findPrincipalComments($course){
      $qb = $this->addActiveQuery();

      $qb->andWhere("commentcourse.course = :course")->setParameter("course", $course);
      $qb->andWhere("commentcourse.active = true");
      $qb->andWhere("commentcourse.reference is null");


      $query = $qb->getQuery();

      return $query->getResult();
    }
}
