<?php

namespace AppBundle\Repository;

/**
 * CourseClassRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class CourseClassRepository extends \Doctrine\ORM\EntityRepository
{

    /**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null)
    {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('courseclass'))
            ->from('AppBundle:CourseClass', 'courseclass');

        return $qb;
    }

    public function validateCourseClassDescription($entity)
    {
        $qb = $this->addActiveQuery();

        $qb->andWhere("courseclass.description = :description")
            ->setParameter("description", $entity->getDescription());

        $flag = true;

        if ($entity->getId() != null) {
            // Buscar lista de ids com username ou email
            $results = $qb->select('courseclass.id')->getQuery()->getScalarResult();
            $ids = array_map('current', $results);

            // Caso a lista tiver mais de 1 elemento, retorne false
            if (count($ids) > 1) {
                $flag = false;
            }
            // Caso a lista conter um elemento
            elseif (count($ids) == 1) {
                //e esse elemento for diferente ao id de cadastro retorne false
                if (!in_array($entity->getId(), $ids)) {
                    $flag = false;
                };
            }
        } else {
            $query = $qb->getQuery();
            if (count($query->getResult()) > 0) {
                $flag = false;
            }
        }

        return $flag;
    }

    /**
    * Busca possíveis registros incorretos
    * @return array Array de registros.
    */
    public function getFinishesClass(){
        $qb = $this->addActiveQuery();
  
        $qb->andWhere("courseclass.dtEnd < :dtEnd")
        ->setParameter("dtEnd", date("Y-m-d H:i:s"));
  
        $query = $qb->getQuery();
  
        return $query->getResult();
      }
}
