<?php

namespace AppBundle\Repository;

use AppBundle\Entity\InscriptionStatus;
use AppBundle\Service\StringService;

/**
 * CourseRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class CourseRepository extends \Doctrine\ORM\EntityRepository
{

    /**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null)
    {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('c'))
            ->from('AppBundle:Course', 'c');

        $qb->andWhere("c.active = true");
        return $qb;
    }

    public function findAvailableCourses($user)
    {

        $conn = $this->getEntityManager()->getConnection();

        $sql = "
        select distinct(id), title, slug, cover, linkTrailExternal, pontuation, realizado, nota, dt_conclusao, tentativas, provas from (
            select  distinct(c.id) as 'id', 
            c.title as 'title', 
            c.slug as 'slug',  
            c.cover as 'cover', 
            c.link_trail_external as 'linkTrailExternal', 
            c.pontuation as 'pontuation', 
            ((SELECT count(*)*100 FROM inscription_lesson AS iil join inscription on inscription.id = iil.inscription_id WHERE iil.inscription_id = i.id and iil.finished IS not NULL and i.user_id = :user_id) div (select count(*) from lesson as l join module as m on l.module_id = m.id where m.course_id = i.course_id)) as 'realizado', 
            (SELECT SUM(grade) DIV (select count(*) from evaluation as e join module m on m.id = e.module_id where m.course_id = c.id) FROM ( SELECT MAX(uee.grade) AS grade, uee.user_id AS uee_user, uee.evaluation_id AS uee_ev, uee.course_id AS uee_course FROM user_evaluation uee GROUP BY uee.evaluation_id, uee.user_id, uee.course_id) AS tbl WHERE uee_user = :user_id AND uee_course = c.id) as 'nota', 
            (SELECT ue.dt_creation FROM user_evaluation AS ue WHERE ue.user_id = :user_id and ue.course_id = i.course_id order by id asc limit 1) AS 'dt_conclusao', 
            (SELECT count(*) FROM user_evaluation AS ue WHERE ue.user_id = :user_id and ue.course_id = i.course_id) AS 'tentativas', 
            (select count(*) from evaluation as e join module as m on e.module_id = m.id where m.course_id = i.course_id) AS 'provas' 
            from course c 
            left join inscription i on (i.course_id = c.id and i.user_id = :user_id)
            left join course_access_control cac on cac.course_id = c.id 
            where  c.active = true 
            and c.modality = 'EAD' 
            and c.dt_cancel is null 
            and (i.user_id = :user_id or (cac.access = 'Todos' or cac.access = :group_id)) 
            group by c.id

            union all
        
            select  distinct(c.id) as 'id', 
            c.title as 'title', 
            c.slug as 'slug',  
            c.cover as 'cover', 
            c.link_trail_external as 'linkTrailExternal', 
            c.pontuation as 'pontuation', 
            0 as 'realizado',
            0 as 'nota',
            0 as 'dt_conclusao',
            0 as 'tentativas',
            0 as 'provas'
            from course c
            left join course_access_control cac on cac.course_id = c.id 
            where  c.active = true 
            and c.modality = 'EAD' 
            and c.dt_cancel is null
            and c.id not in 
            (select inscription.course_id from inscription where inscription.user_id = :user_id)
            and  (cac.access = 'Todos' or cac.access = :group_id)
            
    ) as x group by id order by id desc
        ";
        $stmt = $conn->prepare($sql);
        $stmt->execute(array('user_id' => $user->getId(), 'group_id' => ($user->getUsergroup() ? $user->getUsergroup()->getId() : 10000)));

        return $stmt->fetchAll();
    }

    public function getInscritiptionCourse($user, $status = null, $finished = false, $limit = 10)
    {
        $qb = $this->addActiveQuery();

        $qb->join('c.inscriptions', 'i')
            ->andWhere('i.user = :user')
            ->setParameter('user', $user);

        if ($status!=null) {
            $qb->andWhere("i.inscription_status = :status")
            ->setParameter("status", $status);
        }
        if ($finished) {
            $qb->join('i.inscriptionlessons', 'il')
            ->andWhere("il.finished is not null");
        } else {
            $qb->leftJoin('i.inscriptionlessons', 'il')
            ->andWhere("il.finished is null");
        }
        $qb->orderBy('c.id', 'desc');

        if ($limit != null) {
            $qb->setMaxResults($limit);
        }
        return $qb->getQuery()->getResult();
    }

    public function findOtherCourses($course, $max = 4)
    {
        $qb = $this->addActiveQuery();

        $qb->andWhere('c.id != :course')
          ->setParameter('course', $course->getId());
        $qb->andWhere("c.company is null");
        $qb->setMaxResults($max);

        return $qb->getQuery()->getResult();
    }

    public function findForSearch($user, $query)
    {
        $qb = $this->addActiveQuery();

        $query = StringService::stripAccents($query);
        $query = strtolower($query);
        $query = str_replace(" ", "%", $query);

        $qb->leftJoin('c.inscriptions', 'i');
        $qb->leftJoin('c.courseAccessControls', 'courseAccessControls');

        if($user->getUsergroup()){
            $qb->andWhere('i.user = :user or (courseAccessControls.access = :userGroup1 or courseAccessControls.access = :userGroup2 ) ');
            $qb->setParameter('user', $user);
            $qb->setParameter('userGroup1', "Todos");
            $qb->setParameter('userGroup2', $user->getUsergroup()->getId());
        }else{
            $qb->andWhere('i.user = :user or (courseAccessControls.access = :userGroup1 )');
            $qb->setParameter('user', $user);
            $qb->setParameter('userGroup1', "Todos");
        }

        $qb->andWhere($qb->expr()->like($qb->expr()->lower('c.title'), ':query') ." or ". $qb->expr()->like($qb->expr()->lower('c.description'), ':query'))
          ->setParameter(':query', "%" . $query . "%");

        // $qb->andWhere("lower(c.title) like :query or lower(c.description) like :query ")
        //   ->setParameter(':query', "%" . $query . "%");

        $qb->andWhere("c.active = true");

        // return $qb->getQuery()->getResult();
        return $qb->getQuery();
    }

    public function getActives($onlyPresential = false, $ids = null, $contains=false)
    {
        $qb = $this->addActiveQuery();
        $qb->addOrderBy('c.name', 'asc')
        ->addOrderBy('c.title', 'asc');
        if($onlyPresential){
            $qb->andWhere("c.modality = 'EAD'");
        }
        if($ids){
            if($contains){
                $qb->andWhere('c.id IN ('.implode(",", $ids).')');
            }else{
                $qb->andWhere('c.id not IN ('.implode(",", $ids).')');
            }
        }

        return $qb->getQuery()->getResult();
    }

    public function getCoursesFinished($user, $course = null)
    {
        $qb = $this->addActiveQuery();

        $qb->join('c.inscriptions', 'i');
        $qb->join('i.inscriptionlessons', 'il');
        $qb->leftJoin('AppBundle:UserEvaluation', 'ue', \Doctrine\ORM\Query\Expr\Join::WITH, 'i.user=ue.user and c.id=ue.course');
        $qb->andWhere('i.user = :user');
        $qb->setParameter('user', $user->getId());
        $qb->andWhere('i.inscription_status = :aprovado');
        $qb->setParameter('aprovado', InscriptionStatus::APROVADO);
        $qb->andWhere('il.finished is not null');
        $qb->andWhere("c.modality = 'EAD'");
        $qb->groupBy('c.id');
        $qb->addOrderBy('ue.dtUpdate', 'desc');

        return $qb->getQuery()->getResult();
    }
    
    public function findForApi($categories)
    {
        $ids = array();
        foreach ($categories as $category) {
            $ids[] = $category->getId();
        }
        $qb = $this->addActiveQuery();
        $qb->join('c.category', 'category');
        $qb->andWhere('category.id IN (:ids)')
        ->setParameter('ids', $ids);
        $qb->groupBy('c.name');

        return $qb->getQuery()->getResult();
    }

    public function getOnlyNotEnrolled($user, $status)
    {
        $qb = $this->addActiveQuery();
        $notsResult = $qb->join('c.inscriptions', 'i')
            ->andWhere('i.user = :user')
            ->setParameter('user', $user)
            ->andWhere("i.inscription_status = :status")
            ->setParameter("status", $status)
            ->getQuery()
            ->getResult();

        $notsId = array();
        foreach ($notsResult as $course) {
            array_push($notsId, $course->getId());
        }

        $qb = $this->addActiveQuery();

        $notsId = implode(",", $notsId);

        $qb->leftJoin('c.courseAccessControls', 'courseAccessControls');

        // $qb->andWhere('c.autoInscription = :autoInscription');
        // $qb->setParameter('autoInscription', true);
        if($user->getUsergroup()){
            $qb->andWhere('(courseAccessControls.access = :userGroup1 or courseAccessControls.access = :userGroup2 ) ');
            $qb->setParameter('userGroup1', "Todos");
            $qb->setParameter('userGroup2', $user->getUsergroup()->getId());
        }else{
            $qb->andWhere('(courseAccessControls.access = :userGroup1 )');
            $qb->setParameter('userGroup1', "Todos");
        }
        $qb->andWhere('c.modality = :modality');
        $qb->setParameter('modality', 'EAD');
        if ($notsId) {
            $qb->andWhere($qb->expr()->notIn('c.id', $notsId));
        }
        $qb->orderBy('c.id', 'desc');

        return $qb->getQuery()->getResult();
    }

    public function getCoursesNotFinished($user, $max = null)
    {
        $qb = $this->addActiveQuery();

        $qb->join('c.inscriptions', 'i');
        $qb->join('i.inscriptionlessons', 'il');

        $qb->andWhere('i.user = :user');
        $qb->andWhere('i.inscription_status = :aprovado');
        $qb->andWhere('il.finished is null');
        $qb->andWhere("c.modality = 'EAD'");

        $qb->setParameter('user', $user->getId());
        $qb->setParameter('aprovado', InscriptionStatus::APROVADO);

        $qb->groupBy('c.id');

        if ($max!=null) {
            $qb->setMaxResults($max);
        }

        //->having('count(il.id) >= '. ($this->getTotalLessonCourse($user) / 2)); clausula para validar cursos com aproveitamento de 100%        //->

        //having('count(il.id) >= '. ($this->getTotalLessonCourse($user) / 2)); clausula para validar cursos com aproveitamento acima de 50%

        return $qb->getQuery()->getResult();
    }

    public function getCoursesEvaluationNotFinished($user, $max = null)
    {
        $qb = $this->addActiveQuery();

        $qb->join('c.inscriptions', 'i')
        ->innerJoin("c.modules", "m")
        ->innerJoin("m.evaluations", "e")
        ->join('i.inscriptionlessons', 'il')
        ->andWhere('i.user = :user')
        ->setParameter('user', $user->getId())
        ->andWhere('i.inscription_status = :aprovado')
        ->setParameter('aprovado', InscriptionStatus::APROVADO)
        ->andWhere('il.finished is null')
        ->groupBy('c.id');

        if ($max!=null) {
            $qb->setMaxResults($max);
        }

        //->having('count(il.id) >= '. ($this->getTotalLessonCourse($user) / 2)); clausula para validar cursos com aproveitamento de 100%        //->

        //having('count(il.id) >= '. ($this->getTotalLessonCourse($user) / 2)); clausula para validar cursos com aproveitamento acima de 50%

        return $qb->getQuery()->getResult();
    }

    /**
     * Busca o total geral de aulas de um curso
     * @param User $user
     * */
    public function getTotalLessonCourse($course)
    {
        $qb = $this->addActiveQuery();
        $qb->select('count(l.id) as totalLessons');

        $qb->join('c.modules', 'm')
        ->join('m.lessons', 'l')
        ->andWhere('c.id = :course')
        ->setParameter('course', $course->getId());

        return $qb->getQuery()->getSingleScalarResult();
    }

    /**
     * Busca o total de lições/aulas de um usuário por curso
     * @param User $user
     * @param Course $course
     **/
    public function getLessonsUserCourse($user, $course)
    {
        $qb = $this->addActiveQuery();

        $qb->join('c.inscriptions', 'i')
        ->leftJoin('i.inscriptionlessons', 'il')
        ->leftJoin('il.lesson   ', 'le')
        ->andWhere('il.finished is not null')
        ->andWhere('c.id = :courseid')
        ->setParameter('courseid', $course->getId())
        ->andWhere('i.user = :user')
        ->setParameter('user', $user->getId())
        ->andWhere('i.inscription_status = :aprovado')
        ->setParameter('aprovado', InscriptionStatus::APROVADO);

        return $qb->getQuery()->getResult();
    }

    /**
     * Busca o total de lições/aulas de um usuário por curso
     * @param User $user
     * @param Course $course
     **/
    public function getTotalLessonUserCourse($user, $course)
    {
        $qb = $this->addActiveQuery();
        $qb->select('count(il.id) as totalLesson');

        $qb->join('c.inscriptions', 'i')
        ->leftJoin('i.inscriptionlessons', 'il')
        ->leftJoin('il.lesson   ', 'le')
        ->andWhere('il.finished is not null')
        ->andWhere('c.id = :courseid')
        ->setParameter('courseid', $course->getId())
        ->andWhere('i.user = :user')
        ->setParameter('user', $user->getId())
        ->andWhere('i.inscription_status = :aprovado')
        ->setParameter('aprovado', InscriptionStatus::APROVADO);

        return $qb->getQuery()->getSingleScalarResult();
    }

    /**
     * Busca o total de lições/aulas finalizadas, de um usuário por curso
     * @param User $user
     * @param Course $course
     **/
    public function getTotalLessonUserCourseFinished($user, $course)
    {
        $qb = $this->addActiveQuery();
        $qb->select('count(il.id) as totalLesson');

        $qb->join('c.inscriptions', 'i')
        ->join('i.inscriptionlessons', 'il')
        ->andWhere('c.id = :courseid')
        ->setParameter('courseid', $course->getId())
        ->andWhere('i.user = :user')
        ->setParameter('user', $user->getId())
        ->andWhere('il.finished is not null')
        ->andWhere('i.inscription_status = :aprovado')
        ->setParameter('aprovado', InscriptionStatus::APROVADO);

        return $qb->getQuery()->getSingleScalarResult();
    }

    public function findCourseAprovedAnswer($user)
    {
        $qb = $this->addActiveQuery();
        //$qb->select('c.id', 'c.cover', 'c.name', 'count(CASE WHEN a.correctAnswer = 1 THEN a.correctAnswer ELSE 0 END) as questionCorrect', 'count(q.id) as totalQuestion', 'm.percent');
        $qb->addSelect("m");

        $qb->join('c.modules', 'm')
            ->join('c.inscriptions', 'i')
            ->join('m.questions', 'q')
            ->join('q.answers', 'a')
            ->andWhere('a.user = :user')
            ->setParameter('user', $user->getId())
            ->andWhere('i.user = :userc')
            ->setParameter('userc', $user->getId())
            ->groupBy('c.id', 'm.id')
            ->having('((count(CASE WHEN a.correctAnswer = 1 THEN a.correctAnswer ELSE 0 END) * 100) / count(q.id)) > m.percent');

        return $qb->getQuery()->getResult();
    }

    public function questionsCorrectForCourseUser($user, $course)
    {
        $qb = $this->addActiveQuery();
        $qb->select('count(CASE WHEN a.correctAnswer = 1 THEN a.correctAnswer ELSE 0 END) as questionCorrect');

        $qb->join('c.modules', 'm')
            ->join('m.evaluations', 'e')
            ->join('e.questions', 'q')
            ->join('c.inscriptions', 'i')
            ->join('q.answers', 'a')
            ->join('a.userEvaluation', 'ue')
            ->where('ue.user = :user')
            ->setParameter('user', $user->getId())
            ->andWhere('i.user = :userc')
            ->setParameter('userc', $user->getId())
            ->andWhere('a.correctAnswer = :correctAnswer')
            ->setParameter('correctAnswer', true)
            ->andWhere('c.id = :course')
            ->setParameter('course', $course->getId())
            ->andWhere('i.inscription_status = :aprovado')
            ->setParameter('aprovado', InscriptionStatus::APROVADO);

        return $qb->getQuery()->getSingleScalarResult();
    }

    public function findForTypeaheadSearch($query)
    {
        $qb = $this->addActiveQuery();

        $qb->andWhere($qb->expr()->like($qb->expr()->lower('c.name'), ':query'))
          ->setParameter(':query', "%" . strtolower($query) . "%");
        ;


        return $qb->getQuery()->getArrayResult();
    }

    public function findCourseByIdEvent($codEnv)
    {
        $qb = $this->addActiveQuery();

        $qb->andWhere('c.codEnv = :codEnv');
        $qb->setParameter('codEnv', $codEnv);

        return $qb->getQuery()->getSingleScalarResult();
    }
}
