<?php

namespace AppBundle\Repository;

use Doctrine\ORM\Query\Expr;
use Doctrine\ORM\Query\ResultSetMapping;

/**
 * InscriptionClassRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class InscriptionClassRepository extends \Doctrine\ORM\EntityRepository
{

    /**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null)
    {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('inscription_class'))
            ->from('AppBundle:InscriptionClass', 'inscription_class');

        return $qb;
    }

    public function findTotalInscriptions($class)
    {
        $qb = $this->addActiveQuery();
        $qb->select('count(inscription_class.id) as totalActiveInscriptions');

        $qb->andWhere("inscription_class.courseClass = :courseClass")->setParameter("courseClass", $class);

        return $qb->getQuery()->getSingleScalarResult();
    }

    /**
    * Busca todas as matriculas a partir dos dados informados
    * @param User $user Usuário corrente.
    * @param CourseClass $courseClass Turma a ser pesquisada.
    * @return array Array de registros.
    */
    public function getLastInscriptionByUser($user, $courseClass = null)
    {
        $qb = $this->addActiveQuery();

        $qb->andWhere("inscription_class.user = :user")->setParameter("user", $user);

        if ($courseClass!=null) {
            $qb->andWhere("inscription_class.courseClass = :courseClass")->setParameter("courseClass", $courseClass);
        }

        $qb->orderBy("inscription_class.id", "DESC")->setMaxResults(1);

        return $qb->getQuery()->getOneOrNullResult();
    }

    /**
    * Busca todas as matriculas a partir dos dados informados
    * @param User $user Usuário corrente.
    * @param CourseClass $courseClass Turma a ser pesquisada.
    * @return array Array de registros.
    */
    public function findAnotherInscription($user, $courseClass)
    {
        $qb = $this->addActiveQuery();
        $qb->join("inscription_class.courseClass", "courseClass");

        $qb->andWhere("inscription_class.user = :user")->setParameter("user", $user);
        $qb->andWhere("((courseClass.dtBegin <= :dtBegin and courseClass.dtEnd >= :dtBegin )  or (courseClass.dtBegin <= :dtEnd and courseClass.dtEnd >= :dtEnd))")
        ->setParameter("dtBegin", $courseClass->getDtBegin())
        ->setParameter("dtEnd", $courseClass->getDtEnd());

        $qb->orderBy("inscription_class.id", "DESC")->setMaxResults(1);

        return $qb->getQuery()->getOneOrNullResult();
    }


    /**
     * @param array $get
     * @param bool $flag
     * @return array|\Doctrine\ORM\Query
     */
    public function ajaxTable(array $get, $courseClass = null)
    {
        /* Indexed column (used for fast and accurate table cardinality) */
        $alias = 'inscription_class';
        /* DB table to use */
        $tableObjectName = 'AppBundle:InscriptionClass';
        /**
         * Set to default
         */
        if (!isset($get['columns']) || empty($get['columns'])) {
            $get['columns'] = array('id');
        }
        $aColumns = array();
        foreach ($get['columns'] as $value) {
            if (strpos($value, '.') !== false) {
                $aColumns[] = $value;
            } else {
                $aColumns[] = $alias .'.'. $value;
            }
        }
        $cb = $this->getEntityManager()
        ->getRepository($tableObjectName)
        ->createQueryBuilder($alias);
        //->select(str_replace(" , ", " ", implode(", ", $aColumns)));
        if (isset($get['iDisplayStart']) && $get['iDisplayLength'] != '-1') {
            $cb->setFirstResult((int)$get['iDisplayStart'])
            ->setMaxResults((int)$get['iDisplayLength']);
        }
        $cb->join($alias.".user", "user");
        $cb->join($alias.".courseClass", "course_class");
        $cb->leftJoin('AppBundle:Client', 'client', \Doctrine\ORM\Query\Expr\Join::WITH, 'user.id=client.id');
        /*
        * Ordering
        */
        // if ( isset( $get['iSortCol_0'] ) ){
        //   for ( $i=0 ; $i<intval( $get['iSortingCols'] ) ; $i++ ){
        //     if ( $get[ 'bSortable_'.intval($get['iSortCol_'.$i]) ] == "true" ){
        //       $cb->orderBy($aColumns[ (int)$get['iSortCol_'.$i] ], $get['sSortDir_'.$i]);
        //     }
        //   }
        // }
        /*
            * Filtering
            * NOTE this does not match the built-in DataTables filtering which does it
            * word by word on any field. It's possible to do here, but concerned about efficiency
            * on very large tables, and MySQL's regex functionality is very limited
            */
        if (isset($get['sSearch']) && $get['sSearch'] != '') {
            $aLike = array();
            for ($i=0 ; $i<count($aColumns) ; $i++) {
                if (isset($get['bSearchable_'.$i]) && $get['bSearchable_'.$i] == "true") {
                    $aLike[] = $cb->expr()->like($aColumns[$i], '\'%'. $get['sSearch'] .'%\'');
                }
            }
            if (count($aLike) > 0) {
                $cb->andWhere(new Expr\Orx($aLike));
            } else {
                unset($aLike);
            }
        }

        $cb->andWhere("inscription_class.courseClass = :courseClass")->setParameter("courseClass", $courseClass);

        /*
        * SQL queries
        * Get data to display
        */
        $query = $cb->getQuery();
        return $query->getResult();
    }

    /**
     * @return int
     */
    public function getCount($courseClass=null)
    {
        $query = $this->getEntityManager()
        ->createQuery('SELECT COUNT(inscription_class) FROM AppBundle:InscriptionClass inscription_class join inscription_class.courseClass courseClass where courseClass.id = ?1')
        ->setMaxResults(1)
        ->setParameter(1, $courseClass->getId());
        $aResultTotal = $query->getResult();

        
        return $aResultTotal[0][1];
    }
}
