<?php

namespace AppBundle\Repository;

/**
 * InscriptionLessonRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class InscriptionLessonRepository extends \Doctrine\ORM\EntityRepository
{
    /**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null) {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('inscriptionlesson'))
            ->from('AppBundle:InscriptionLesson', 'inscriptionlesson');

        return $qb;
    }

    /**
    * Busca todas os registros pela matricula informada
    * @param Matricula $inscription.
    * @param boolean $concluded Busca somente os registros finalizados.
    * @return array Array de registros.
    */
    public function findAllByInscription($inscription, $concluded = false){
      $qb = $this->addActiveQuery();

      $qb->andWhere("inscriptionlesson.inscription = :inscription")->setParameter("inscription", $inscription);

      if($concluded){
        $qb->andWhere("inscriptionlesson.finished is not null");
      }

      $query = $qb->getQuery();

      return $query->getResult();
    }

    /**
    * Busca todas os registros pela matricula informada
    * @param Matricula $inscription.
    * @param boolean $concluded Busca somente os registros finalizados.
    * @return array Array de registros.
    */
    public function getMaxInscriptionLesson($inscription){
      $qb = $this->addActiveQuery();

      $qb->andWhere("inscriptionlesson.inscription = :inscription")->setParameter("inscription", $inscription);

      $qb->orderBy('inscriptionlesson.id', 'desc')->setMaxResults(1);

      $query = $qb->getQuery();

      return $query->getOneOrNullResult();
    }

    /**
    * Busca possíveis registros incorretos
    * @return array Array de registros.
    */
    public function getManipulatedRegisters(){
        $qb = $this->addActiveQuery();
  
        $qb->andWhere("inscriptionlesson.loaded = :invalidDate or inscriptionlesson.started = :invalidDate or inscriptionlesson.finished = :invalidDate")
        ->setParameter("invalidDate", '0000-00-00 00:00:00');
        // $qb->andWhere("inscriptionlesson.dtCreation >= :beginnerDate")
        // ->setParameter("beginnerDate", '2020-03-18 00:00:00');
        $qb->andWhere("inscriptionlesson.id >= :id")
        ->setParameter("id", '497580');
  
        $qb->orderBy('inscriptionlesson.id', 'desc');
  
        $query = $qb->getQuery();
  
        return $query->getResult();
      }
}
