<?php

namespace AppBundle\Repository;

use Doctrine\ORM\Query\ResultSetMapping;
use Doctrine\ORM\Query\Expr;

/**
 * IntegrationReturnRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class IntegracaoParticipacaoPontuadaRepository extends \Doctrine\ORM\EntityRepository
{

    /**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null)
    {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('integracao_participacaopontuada'))
            ->from('AppBundle:IntegracaoParticipacaoPontuada', 'integracao_participacaopontuada');

        return $qb;
    }

    public function findPendenteIntegrations()
    {
        $qb = $this->addActiveQuery();
        $now = new \DateTime("now");

        $qb->andWhere("integracao_participacaopontuada.status = 'P'");
        $qb->andWhere("TIMESTAMPDIFF(MINUTE, integracao_participacaopontuada.dateInsert, :now) >= 29")
        ->setParameter("now", $now);
        $query = $qb->getQuery();

        return $query->getResult();
    }
}
