<?php

namespace AppBundle\Repository;

use Doctrine\ORM\Query\ResultSetMapping;
use Doctrine\ORM\Query\Expr;

/**
 * IntegrationReturnRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class IntegrationReturnRepository extends \Doctrine\ORM\EntityRepository
{

    /**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null)
    {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('integration_return'))
            ->from('AppBundle:IntegrationReturn', 'integration_return');

        return $qb;
    }

    public function findPendenteIntegrations()
    {
        $qb = $this->addActiveQuery();
        $now = new \DateTime("now");

        $qb->andWhere("integration_return.status = 'P'");
        $qb->andWhere("TIMESTAMPDIFF(MINUTE, integration_return.dateInsert, :now) >= 29")
        ->setParameter("now", $now);
        $query = $qb->getQuery();

        return $query->getResult();
    }
}
