<?php

namespace AppBundle\Repository;

use Doctrine\ORM\Query\Expr\Join;

/**
 * IqaCicleRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class IqaCicleRepository extends \Doctrine\ORM\EntityRepository
{

    /**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null)
    {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('iqa'))
            ->from('AppBundle:IqaCicle', 'iqa');

        return $qb;
    }

    public function getActiveIqaCicle()
    {
        $qb = $this->addActiveQuery();

        $dateToday = new \DateTime();

        $qb->andWhere('iqa.beginDate <= :dateToday');
        $qb->andWhere('iqa.endDate >= :dateToday');
        $qb->setParameter("dateToday", $dateToday);

        $qb->setMaxResults(1);

        $query = $qb->getQuery();

        return $query->getOneOrNullResult();
    }
}