<?php

namespace AppBundle\Repository;

/**
 * LearningTrailRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class LearningTrailRepository extends \Doctrine\ORM\EntityRepository
{
    /**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null) {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('learningTrail'))
            ->from('AppBundle:LearningTrail', 'learningTrail');

        return $qb;
    }

    public function findAvailable($user, $isClient = false) {
        $qb = $this->addActiveQuery();
        
        if($isClient){
            $qb
            ->andWhere('learningTrail.public = 1 or learningTrail.numEmp is null or learningTrail.numEmp = :numEmp')
            ->setParameter('numEmp', $user->getNumEnterprise());
        }
        $query = $qb->getQuery();
        return $query->getResult();
    }
}
