<?php

namespace AppBundle\Repository;

use AppBundle\Entity\InscriptionStatus;

/**
 * LessonRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class LessonRepository extends \Doctrine\ORM\EntityRepository
{

    /**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null)
    {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('l'))
            ->from('AppBundle:Lesson', 'l');

        return $qb;
    }

    /**
     * Retorna a próxima aula
     * @param Lesson $module
     */
    public function getNextLesson($lesson)
    {
        $qb = $this->addActiveQuery();
        $qb->andWhere('l.module = :module')->setParameter('module', $lesson->getModule()->getId());
        $qb->andWhere('l.position > :position')->setParameter('position', $lesson->getPosition());
        $qb->orderBy('l.position', 'ASC')->setMaxResults(1);
        $nextLesson = $qb->getQuery()->getOneOrNullResult();
        if ($nextLesson == null) {
            $nextModule = $this->getEntityManager()->getRepository('AppBundle:Module')->getNextModule($lesson->getModule());
            if ($nextModule != null) {
                $nextLesson = $this->findFirstByModule($nextModule);
            }
        }
        return $nextLesson;
    }

    /**
     * @param Module $module
     * @return array Array de registros
     */
    public function getMaxLessonPositionByModule($module)
    {
        $qb = $this->addActiveQuery();
        $qb->select('max(l.position) as position');
        $qb->andWhere('l.module = :module')
           ->setParameter('module', $module->getId());
        $query = $qb->getQuery();
        return $query->getSingleScalarResult();
    }

    public function findByCourse($course)
    {
        $qb = $this->addActiveQuery();
        $qb->join('l.module', 'm')
           ->andWhere('m.course = :course')
           ->setParameter('course', $course->getId());
        $query = $qb->getQuery();
        return $query->getResult();
    }

    /**
     * Encontra a primeira aula do módulos
     * @param  module $module
     */
    public function findFirstByModule($module)
    {
        $qb = $this->addActiveQuery();
        $qb->andWhere('l.module = :module')->setParameter('module', $module);
        $qb->orderBy('l.position', 'ASC')->setMaxResults(1);
        $query = $qb->getQuery();
        return $query->getOneOrNullResult();
    }

    /**
     * Encontra a primeira aula do módulos
     * @param  module $module
     */
    public function findLastByModule($module)
    {
        $qb = $this->addActiveQuery();
        $qb->andWhere('l.module = :module')->setParameter('module', $module);
        $qb->orderBy('l.position', 'DESC')->setMaxResults(1);
        $query = $qb->getQuery();
        return $query->getOneOrNullResult();
    }

    public function getLessonsFinished($user)
    {
        $qb = $this->addActiveQuery();

        $qb->join('l.inscriptionlessons', 'il')
            ->join('il.inscription', 'i')
            ->andWhere('i.user = :user')
            ->setParameter('user', $user->getId())
            ->andWhere('i.inscription_status = :aprovado')
            ->setParameter('aprovado', InscriptionStatus::APROVADO)
            ->andWhere('il.finished is not null');

        $query = $qb->getQuery();

        return $query->getResult();
    }

    public function getAllLessons($user)
    {
        $qb = $this->addActiveQuery();

        $qb->join('l.inscriptionlessons', 'il')
            ->join('il.inscription', 'i')
            ->andWhere('i.user = :user')
            ->setParameter('user', $user->getId())
            ->andWhere('i.inscription_status = :aprovado')
            ->setParameter('aprovado', InscriptionStatus::APROVADO);

        $query = $qb->getQuery();

        return $query->getResult();
    }
}
