<?php

namespace AppBundle\Repository;

use AppBundle\Entity\InscriptionStatus;

/**
 * ModuleRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ModuleRepository extends \Doctrine\ORM\EntityRepository
{

    /**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null) {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('m'))
            ->from('AppBundle:Module', 'm');

        return $qb;
    }

    /**
     * Encontra o primeiro módulo do curso
     * @param Course $course
     */
    public function getOrderedModules($course) {
        $qb = $this->addActiveQuery();
        $qb->andWhere('m.course = :course')->setParameter('course', $course);
        $qb->orderBy('m.position', 'ASC');
        return $qb->getQuery()->getResult();
    }

    /**
     * Encontra o primeiro módulo do curso
     * @param Course $course
     */
    public function findFirstByCourse($course) {
        $qb = $this->addActiveQuery();
        $qb->andWhere('m.course = :course')->setParameter('course', $course);
        $qb->orderBy('m.position', 'ASC')->setMaxResults(1);
        $query = $qb->getQuery();
        return $query->getOneOrNullResult();
    }

    /**
     * Retorna o próximo módulo
     * @param Module $module
     */
    public function getNextModule($module) {
        $qb = $this->addActiveQuery();
        $qb->andWhere('m.course = :course')->setParameter('course', $module->getCourse());
        $qb->andWhere('m.position > :position')->setParameter('position', $module->getPosition());
        $qb->orderBy('m.position', 'ASC')->setMaxResults(1);
        return $qb->getQuery()->getOneOrNullResult();
    }

    /**
     * Retorna a maior posição do módulo
     * @param Course $course
     */
    public function getMaxModulePositionByCourse($course) {
        $qb = $this->addActiveQuery();
        $qb->select('max(m.position) as position');
        $qb->andWhere('m.course = :course')->setParameter('course', $course->getId());
        $query = $qb->getQuery();
        return $query->getSingleScalarResult();
    }

    /**
     * Retorna a maior posição do módulo
     * @param Course $course
     */
    public function getMaxModuleByCourse($course) {
        $qb = $this->addActiveQuery();
        $qb->andWhere('m.course = :course')->setParameter('course', $course->getId());
        $qb->orderBy("m.position", "DESC")->setMaxResults(1);
        return $qb->getQuery()->getOneOrNullResult();
    }

    public function questionsCorrectForModuleUser($user, $module)
    {
        $qb = $this->addActiveQuery();
        $qb->select('count(CASE WHEN a.correctAnswer = 1 THEN a.correctAnswer ELSE 0 END) as questionCorrect');

        $qb->join('m.questions', 'q')
            ->join('m.course', 'c')
            ->join('c.inscriptions', 'i')
            ->join('q.answers', 'a')
            ->where('a.user = :user')
            ->setParameter('user', $user->getId())
            ->andWhere('i.user = :userc')
            ->setParameter('userc', $user->getId())
            ->andWhere('m.id = :module')
            ->setParameter('module', $module->getId())
            ->andWhere('i.inscription_status = :aprovado')
            ->setParameter('aprovado', InscriptionStatus::APROVADO);

        return $qb->getQuery()->getSingleScalarResult();
    }

    public function getLastLessonPosition($moduleId)
    {
        $qb = $this->addActiveQuery();
        $qb->select('max(ls.position)');

        $qb->join('m.lessons', 'ls')
            ->where('m.id = :moduleId')->setParameter('moduleId', $moduleId);

        return $qb->getQuery()->getSingleScalarResult();
    }

    public function getLastLesson($moduleId)
    {
        $qb = $this->addActiveQuery();
        $qb->select('max(ls.position)');

        $qb->join('m.lessons', 'ls')
            ->where('m.id = :moduleId')->setParameter('moduleId', $moduleId);

        return $qb->getQuery()->getSingleScalarResult();
    }
}
