<?php

namespace AppBundle\Repository;

use AppBundle\Entity\ParticipantStatus;
use AppBundle\Entity\Course;
use Doctrine\ORM\Query\ResultSetMapping;
use Doctrine\ORM\Query\Expr;

/**
 * ParticipantRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ParticipantRepository extends \Doctrine\ORM\EntityRepository
{

    /**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null)
    {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('p'))
            ->from('AppBundle:Participant', 'p');

        return $qb;
    }

    public function getInscriptionsByCourseInDateCurrent($course)
    {
        $qb = $this->addActiveQuery();

        $qb->select('count(p.id) as total');

        $dateToday = new \DateTime();

        $qb->innerJoin('p.course', 'c');
        $qb->andWhere("p.course = :course")->setParameter("course", $course);
        $em = $this->getEntityManager();
        $inscriptionStatusInscrito = $em->getReference('AppBundle:ParticipantStatus', ParticipantStatus::INSCRITO);
        $inscriptionStatusMatriculado = $em->getReference('AppBundle:ParticipantStatus', ParticipantStatus::MATRICULADO);

        $qb->andWhere("p.participant_status = :inscriptionStatusInscrito or p.participant_status = :inscriptionStatusMatriculado");
        $qb->setParameter("inscriptionStatusInscrito", $inscriptionStatusInscrito);
        $qb->setParameter("inscriptionStatusMatriculado", $inscriptionStatusMatriculado);


        $query = $qb->getQuery();

        // return $query->getResult();
        return $query->getSingleScalarResult();
    }

    public function getInscriptionsByCoursePresencial($course, $inscriptionStatus)
    {
        $qb = $this->addActiveQuery();

        $dateToday = new \DateTime();
        // $inscriptionStatusWaiting = 1;

        $qb->innerJoin('p.course', 'c');

        $qb->andWhere("p.course = :course")->setParameter("course", $course);

        $qb->andWhere("p.inscription_status = :inscription_status");
        $qb->setParameter("inscription_status", $inscriptionStatus);

        $qb->andWhere('c.dtInitial < :dateToday');
        $qb->andWhere('c.dtEnd > :dateToday');
        $qb->setParameter("dateToday", $dateToday);

        $qb->orderBy('p.dtCreation');

        $query = $qb->getQuery();

        return $query->getResult();
    }

    /**
    * Busca todas as matriculas a partir dos dados informados
    * @param User $user Usuário corrente.
    * @param Course $course Curso a ser pesquisado.
    * @param InscriptionStatus $inscriptionstatus Status da matrícula.
    * @return array Array de registros.
    */
    public function getLastInscriptionByUser($user, $course = null)
    {
        $qb = $this->addActiveQuery();

        $qb->andWhere("p.user = :user")->setParameter("user", $user);

        if ($course!=null) {
            $qb->andWhere("p.course = :course")->setParameter("course", $course);
            $data = new \DateTime();

            // $qb
        //   ->andWhere('(p.dtBegin <= :begin and p.dtEnd >= :end) or p.dtBegin is null ')
        //   ->setParameter('begin', $data->format('Y-m-d H:i:s'))
        //   ->setParameter('end', $data->format('Y-m-d H:i:s'));
        }

        $qb->orderBy("p.id", "DESC")->setMaxResults(1);

        return $qb->getQuery()->getOneOrNullResult();
    }

    /**
    * Busca todas as matriculas a partir dos dados informados
    * @param User $user Usuário corrente.
    * @param Course $course Curso a ser pesquisado.
    * @param InscriptionStatus $inscriptionstatus Status da matrícula.
    * @return array Array de registros.
    */
    public function getLastInscriptionByUserForApi($user, $course)
    {
        $qb = $this->addActiveQuery();

        $qb->andWhere("p.user = :user")->setParameter("user", $user);

        $qb->andWhere("p.course = :course")->setParameter("course", $course);

        $qb->orderBy("p.id", "DESC")->setMaxResults(1);

        return $qb->getQuery()->getOneOrNullResult();
    }

    /**
    * Verifica se o usuário possui uma matricula ativa no curso
    * @param User $user Usuário a ser pesquisado.
    * @param Course $course Curso a ser pesquisado.
    * @return boolean
    */
    public function verifyParticipant($user, $course)
    {
        $inscriptions = $this->findInscriptionByUser($user, $course, true);
        return count($inscriptions) > 0 ? true : false;
    }

    /**
    * Busca todas as matriculas a partir dos dados informados
    * @param User $user Usuário corrente.
    * @param Course $course Curso a ser pesquisado.
    * @param InscriptionStatus $inscriptionstatus Status da matrícula.
    * @return array Array de registros.
    */
    public function findParticipantsByUser($user, $course = null, $active = false)
    {
        $qb = $this->addActiveQuery();

        $qb->andWhere("p.user = :user")->setParameter("user", $user);

        if ($course!=null) {
            $qb->andWhere("p.course = :course")->setParameter("course", $course);
        }

        if ($active!=null) {
            $em = $this->getEntityManager();
            $inscriptionStatusInscrito = $em->getReference('AppBundle:ParticipantStatus', ParticipantStatus::INSCRITO);
            $inscriptionStatusMatriculado = $em->getReference('AppBundle:ParticipantStatus', ParticipantStatus::MATRICULADO);
            $qb->andWhere("p.participant_status = :inscriptionStatusInscrito or p.participant_status = :inscriptionStatusMatriculado");
            $qb->setParameter("inscriptionStatusInscrito", $inscriptionStatusInscrito);
            $qb->setParameter("inscriptionStatusMatriculado", $inscriptionStatusMatriculado);
        }

        $query = $qb->getQuery();

        return $query->getResult();
    }

    /**
    * Busca todas as matriculas a partir dos dados informados
    * @param User $user Usuário corrente.
    * @param Course $course Curso a ser pesquisado.
    * @param InscriptionStatus $inscriptionstatus Status da matrícula.
    * @return array Array de registros.
    */
    public function findOneParticipantByUser($user, $course = null, $active = false)
    {
        $qb = $this->addActiveQuery();

        $qb->andWhere("p.user = :user")->setParameter("user", $user);

        if ($course!=null) {
            $qb->andWhere("p.course = :course")->setParameter("course", $course);
        }

        if ($active!=null) {
            $em = $this->getEntityManager();
            $inscriptionStatusInscrito = $em->getReference('AppBundle:ParticipantStatus', ParticipantStatus::INSCRITO);
            $inscriptionStatusMatriculado = $em->getReference('AppBundle:ParticipantStatus', ParticipantStatus::MATRICULADO);
            $qb->andWhere("p.participant_status = :inscriptionStatusInscrito or p.participant_status = :inscriptionStatusMatriculado");
            $qb->setParameter("inscriptionStatusInscrito", $inscriptionStatusInscrito);
            $qb->setParameter("inscriptionStatusMatriculado", $inscriptionStatusMatriculado);
        }

        $query = $qb->getQuery()->setMaxResults(1);

        return $query->getOneOrNullResult();
    }

    /**
     * Retorna o total de inscritos no curso de acordo com os parâmetros informados.
     * @param Course $course
     * @param InscriptionStatus $status Status da inscrição a ser buscada
     * @return array Array de registros
     */
    public function getCountInscriptions(Course $course, InscriptionStatus $status = null)
    {
        $qb = $this->addActiveQuery();

        $qb->select('count(p.id) as total');

        $qb->andWhere('p.course = :course')
           ->setParameter('course', $course->getId());

        if ($status!=null) {
            $qb->andWhere('p.inscription_status = :status')
             ->setParameter('status', $status->getId());
        }

        $query = $qb->getQuery();

        return $query->getSingleScalarResult();
    }

    public function findTotalActiveInscriptions($course, $inscriptionStatusAprovado)
    {
        $qb = $this->addActiveQuery();
        $qb->select('count(p.id) as totalActiveInscriptions');

        $qb->andWhere("p.course = :course")->setParameter("course", $course);
        $qb->andWhere("p.inscription_status = :inscription_status")->setParameter("inscription_status", $inscriptionStatusAprovado);

        return $qb->getQuery()->getSingleScalarResult();
    }

    /**
   * @param array $get
   * @param bool $flag
   * @return array|\Doctrine\ORM\Query
   */
    public function ajaxTable(array $get, $course = null, $presential=false, $count = false)
    {
        /* Indexed column (used for fast and accurate table cardinality) */
        $alias = 'p';
        /* DB table to use */
        $tableObjectName = 'AppBundle:Participant';
        /**
         * Set to default
         */
        if (!isset($get['columns']) || empty($get['columns'])) {
            $get['columns'] = array('id');
        }
        $aColumns = array();
        foreach ($get['columns'] as $value) {
            if (strpos($value, '.') !== false) {
                $aColumns[] = $value;
            } else {
                $aColumns[] = $alias .'.'. $value;
            }
        }
        $cb = $this->getEntityManager()
        ->getRepository($tableObjectName)
        ->createQueryBuilder($alias);
        //->select(str_replace(" , ", " ", implode(", ", $aColumns)));
        if(!$count){
            if (isset($get['iDisplayStart']) && $get['iDisplayLength'] != '-1') {
                $cb->setFirstResult((int)$get['iDisplayStart'])
                ->setMaxResults((int)$get['iDisplayLength']);
            }
        }
        $cb->join($alias.".user", "user");
        $cb->leftJoin('AppBundle:Client', 'client', \Doctrine\ORM\Query\Expr\Join::LEFT_JOIN, 'user.id=client.id');
        $cb->leftJoin($alias.".course", "course");
        $cb->leftJoin($alias.".participant_status", "participant_status");
        /*
         * Ordering
         */
        // if ( isset( $get['iSortCol_0'] ) ){
        //   for ( $i=0 ; $i<intval( $get['iSortingCols'] ) ; $i++ ){
        //     if ( $get[ 'bSortable_'.intval($get['iSortCol_'.$i]) ] == "true" ){
        //       $cb->orderBy($aColumns[ (int)$get['iSortCol_'.$i] ], $get['sSortDir_'.$i]);
        //     }
        //   }
        // }
        /*
           * Filtering
           * NOTE this does not match the built-in DataTables filtering which does it
           * word by word on any field. It's possible to do here, but concerned about efficiency
           * on very large tables, and MySQL's regex functionality is very limited
           */
        if (isset($get['sSearch']) && $get['sSearch'] != '') {
            $aLike = array();
            for ($i=0 ; $i<count($aColumns) ; $i++) {
                if (isset($get['bSearchable_'.$i]) && $get['bSearchable_'.$i] == "true") {
                    $aLike[] = $cb->expr()->like($aColumns[$i], '\'%'. $get['sSearch'] .'%\'');
                }
            }
            if (count($aLike) > 0) {
                $cb->andWhere(new Expr\Orx($aLike));
            } else {
                unset($aLike);
            }
        }

        if ($course!=null) {
            $cb->andWhere("p.course = :course")->setParameter("course", $course);
        }
        if($presential){
            $cb->andWhere("course.modality = :presencial")->setParameter("presencial", Course::MODALITY_PRESENCIAL);
        }

        /*
         * SQL queries
         * Get data to display
         */
        $query = $cb->getQuery();
        return $query->getResult();
    }

    /**
     * @return int
     */
    public function getCount($course=null, $presential=false)
    {
        if ($course) {
            $query = $this->getEntityManager()
            ->createQuery('SELECT COUNT(p) FROM AppBundle:Participant p join p.course course where course.id = ?1')
            ->setMaxResults(1)
            ->setParameter(1, $course->getId());
            $aResultTotal = $query->getResult();
        } else {
            if($presential){
                $query = $this->getEntityManager()
                ->createQuery('SELECT COUNT(p) FROM AppBundle:Participant p join p.course course where course.modality = ?1')
                ->setMaxResults(1)
                ->setParameter(1, Course::MODALITY_PRESENCIAL);
                
                $aResultTotal = $query->getResult();
            }else{
                $aResultTotal = $this->getEntityManager()
                ->createQuery('SELECT COUNT(p) FROM AppBundle:Participant p')
                ->setMaxResults(1)
                ->getResult();
            }
        }

        
        return $aResultTotal[0][1];
    }
}
