<?php

namespace AppBundle\Repository;

use Doctrine\ORM\Query\Expr\Join;

/**
 * PostRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class PostRepository extends \Doctrine\ORM\EntityRepository
{

    public function findForHome() {
        $qb = $this->addActiveQuery();
        $qb->andWhere('p.active = true')
        ->orderBy("p.dtCreation", "DESC")
        ->setMaxResults(8);

        $query = $qb->getQuery();
        return $query->getResult();
    }
    
    public function findPostsByAuthor($author) {
        $qb = $this->addActiveQuery();
        $qb->andWhere("p.author = :author")->setParameter("author", $author)
        ->andWhere("p.active = true");

        $query = $qb->getQuery();
        return $query->getResult();
    }

    public function findAllLikedPosts($user) {
        $qb = $this->addActiveQuery();
        $qb->join('AppBundle:LikePost', 'lp', Join::WITH, 'p.id = lp.post')
        ->andWhere('lp.user = :user')->setParameter('user', $user)
        ->andWhere("p.active = true");

        $query = $qb->getQuery();
        return $query->getResult();
    }

    public function findAllActivePosts() {
        $qb = $this->addActiveQuery();
        $qb->andWhere('p.active = true')
        ->orderBy("p.dtCreation", "DESC");
        $query = $qb->getQuery();
        return $query->getResult();
    }

    public function findAllByDataCreation() {
        $qb = $this->addActiveQuery();

        $query = $qb->getQuery();
        return $query->getResult();
    }

	/**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null)
    {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('p'))
        ->from('AppBundle:Post', 'p')
        ->orderBy("p.dtCreation", "DESC");;
        return $qb;
    }

}