<?php

namespace AppBundle\Repository;

use AppBundle\Entity\InscriptionStatus;
/**
 * QuestionItemRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class QuestionItemRepository extends \Doctrine\ORM\EntityRepository
{

    /**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null) {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('qi'))
            ->from('AppBundle:QuestionItem', 'qi');

        return $qb;
    }

    public function findRandomByQuestion($question)
    {
        $qb = $this->addActiveQuery();
        $qb->andWhere("qi.question = :question");
        $qb->setParameter('question', $question);
        $qb->addSelect('RAND() as HIDDEN rand')->orderBy('rand');

        return $qb->getQuery()->getResult();
    }

}
