<?php

namespace AppBundle\Repository;

use AppBundle\Entity\InscriptionStatus;

/**
 * QuestionRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class QuestionRepository extends \Doctrine\ORM\EntityRepository
{

    /**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null) {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('q'))
            ->from('AppBundle:Question', 'q');

        return $qb;
    }
    /**
     * Total geral de questoes por usuário
     * @param User $user
     * @return string totalQuestions
     * */
    public function questionsForUser($user)
    {
        $qb = $this->addActiveQuery();
        $qb->select('count(q.id) as totalQuestions');

        $qb->join('q.module', 'm')
            ->join('m.course', 'c')
            ->join('c.inscriptions', 'i')
            ->where('i.user = :user')
            ->setParameter('user', $user->getId())
            ->andWhere('i.inscription_status = :aprovado')
            ->setParameter('aprovado', InscriptionStatus::APROVADO);

        return $qb->getQuery()->getSingleScalarResult();
    }

      /**
     * Total geral de questoes por usuário e curso
     * @param User $user
     * @param Course $course
     * @return string totalQuestions
     * */
    public function questionsForCourseUser($user, $course)
    {
        $qb = $this->addActiveQuery();
        $qb->select('count(q.id) as totalQuestions');

        $qb->join('q.evaluation', 'e')
            ->join('e.module', 'm')
            ->join('m.course', 'c')
            ->join('c.inscriptions', 'i')
            ->where('i.user = :user')
            ->setParameter('user', $user->getId())
            ->andWhere('c.id = :course')
            ->setParameter('course', $course->getId())
            ->andWhere('i.inscription_status = :aprovado')
            ->setParameter('aprovado', InscriptionStatus::APROVADO);

        return $qb->getQuery()->getSingleScalarResult();
    }

    public function questionsForModuleUser($user, $module)
    {
        $qb = $this->addActiveQuery();
        $qb->select('count(q.id) as totalQuestions');

        $qb->join('q.module', 'm')
            ->join('m.course', 'c')
            ->join('c.inscriptions', 'i')
            ->where('i.user = :user')
            ->setParameter('user', $user->getId())
            ->andWhere('m.id = :module')
            ->setParameter('module', $module->getId())
            ->andWhere('i.inscription_status = :aprovado')
            ->setParameter('aprovado', InscriptionStatus::APROVADO);

        return $qb->getQuery()->getSingleScalarResult();
    }

    /**
   * Total geral de questoes por usuário e curso
   * @param Course $course
   * @return string totalQuestions
   * */
  public function questionsForCourse($course)
  {
      $qb = $this->addActiveQuery();
      $qb->select('count(q.id) as totalQuestions');

      $qb->join('q.evaluation', 'e')
          ->join('e.module', 'm')
          ->join('m.course', 'c')
          ->andWhere('c.id = :course')
          ->setParameter('course', $course->getId());

      return $qb->getQuery()->getSingleScalarResult();
  }

  public function findRandomByEvaluation($evaluation)
  {
      $qb = $this->addActiveQuery();
      $qb->andWhere("q.evaluation = :evaluation");
      $qb->setParameter('evaluation', $evaluation);
      if($evaluation->getNumberQuestions() != null){
        $qb->setMaxResults($evaluation->getNumberQuestions());
      }
      $qb->addSelect('RAND() as HIDDEN rand')->orderBy('rand');

      return $qb->getQuery()->getResult();
  }

}
