<?php

/*
 * This file is part of the Claroline Connect package.
 *
 * (c) Claroline Consortium <consortium@claroline.net>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace AppBundle\Repository;

use UserBundle\Entity\User;
use AppBundle\Entity\Lesson;
use Doctrine\ORM\EntityRepository;

class Scorm12ScoTrackingRepository extends EntityRepository
{
    public function findAllTrackingsByUserAndResource(
        User $user,
        Lesson $lesson
    )
    {
        $dql = '
            SELECT t
            FROM AppBundle\Entity\Scorm12ScoTracking t
            JOIN t.sco s
            WHERE t.user = :user
            AND s.lesson = :lesson
        ';

        $query = $this->_em->createQuery($dql);
        $query->setParameter('user', $user);
        $query->setParameter('lesson', $lesson);

        return $query->getResult();
    }
}
