<?php

namespace AppBundle\Repository;

/**
 * JobRoleRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class SectorRepository extends \Doctrine\ORM\EntityRepository
{
    /**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null)
    {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('s'))
            ->from('AppBundle:Sector', 's');

        return $qb;
    }

    public function findForSearch($query, $isResultArray = false)
    {
        $qb = $this->addActiveQuery();

        $qb->andWhere($qb->expr()->like($qb->expr()->lower('s.name'), ':query'))
          ->setParameter(':query', "%" . strtolower($query) . "%");

        $query = $qb->getQuery();

        return $isResultArray ? $query->getArrayResult() : $query->getResult();
    }
}
