<?php

namespace AppBundle\Repository;

/**
 * SurveyAnswerRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class SurveyAnswerRepository extends \Doctrine\ORM\EntityRepository
{

    /**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null) {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('surveyanswer'))
            ->from('AppBundle:SurveyAnswer', 'surveyanswer');

        return $qb;
    }

    public function findAnswersGroupedBy($course)
    {
        $qb = $this->addActiveQuery();
        $qb->andWhere("surveyanswer.course = :course");
        $qb->setParameter('course', $course);
        $qb->groupBy('surveyanswer.user');

        return $qb->getQuery()->getResult();
    }

}
