<?php

namespace AppBundle\Repository;

use Doctrine\ORM\Query\ResultSetMapping;

use UserBundle\Entity\User;
use AppBundle\Entity\Evaluation;

/**
 * UserEvaluationRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class UserEvaluationRepository extends \Doctrine\ORM\EntityRepository
{
    /**
   * Adiciona filtros para selecionar apenas registros ativos à query.
   * @param QueryBuilder $qb Query inicial.
   * @return QueryBuilder Query com filtros.
   */
  public function addActiveQuery(QueryBuilder $qb = null)
  {
      $em = $this->getEntityManager();

      if (is_null($qb)) {
          $qb = $em->createQueryBuilder();
      }

      $qb->select(array('userEvaluation'))
          ->from('AppBundle:UserEvaluation', 'userEvaluation');

      return $qb;
  }

  /**
  * Busca todas as matriculas a partir dos dados informados
  * @param String $mat_colaborador Usuário corrente - unimed.
  * @param String $codEvn Curso a ser pesquisado - unimed.
  * @return array Array de registros.
  */
  public function getEvaluationUserEvent($mat_colaborador=null, $codEvn=null, $limit = 500)
  {
      $qb = $this->addActiveQuery();
      $qb->join("userEvaluation.user", "user")
      ->leftJoin('AppBundle:Client', 'client', \Doctrine\ORM\Query\Expr\Join::WITH, 'user.id=client.id')
      ->leftJoin("userEvaluation.evaluation", "evaluation")
      ->leftJoin("evaluation.module", "module")
      ->leftJoin("module.course", "course")
      ->leftJoin("userEvaluation.course", "course_2");

      if ($mat_colaborador!=null) {
          $qb->andWhere('client.mat_colaborador = :mat_colaborador')
            ->setParameter('mat_colaborador', $mat_colaborador);
      }

      if ($codEvn!=null) {
          $qb->andWhere('course.codeevent = :codeevent or course_2.codeevent = :codeevent')
            ->setParameter('codeevent', $codEvn);
      }
      $qb->andWhere('(userEvaluation.status = false or userEvaluation.status is null)');

      if($limit != null){
          $qb->setMaxResults($limit);
      }

      $query = $qb->getQuery();

      return $query->getResult();
  }

  /**
  * Busca todas as matriculas a partir dos dados informados
  * @param String $codEvn Curso a ser pesquisado - unimed.
  * @return array Array de registros.
  */
  public function getEvaluationEvent($codEvn=null)
  {
      $qb = $this->addActiveQuery();
      $qb->join("userEvaluation.evaluation", "evaluation")
    ->join("evaluation.course", "course");

      if ($codEvn!=null) {
          $qb->andWhere('course.codeevent = :codeevent')
      ->setParameter('codeevent', $codEvn);
      }

      $query = $qb->getQuery();

      return $query->getResult();
  }

  /**
   *
   *
   */
  public function getMediaNotas($user=null, $course=null, $total=true)
  {
      $em = $this->getEntityManager();
      $qb = $em->createQueryBuilder();

      if ($total) {
          $qb->select('count(userevaluation.id) as total');
      } else {
          $qb->select('SUM(userevaluation.grade) as notas');
      }

      $qb->from('AppBundle:UserEvaluation', 'userevaluation');

      if ($user!=null) {
          $qb->andWhere('userevaluation.user = :user')
            ->setParameter('user', $user->getId());
      }

      if ($course!=null) {
          $qb->leftJoin('userevaluation.evaluation', 'evaluation');
          $qb->leftJoin('evaluation.module', 'module');

          $qb->andWhere('module.course = :course')
            ->setParameter('course', $course->getId());
      }


      $query = $qb->getQuery();

      return $query->getSingleResult();
  }


  /**
   *
   *
   */
  public function getMelhoresNotas($user=null, $course=null, $evaluation = null)
  {
      $em = $this->getEntityManager();
      $qb = $em->createQueryBuilder();
      $qb->addSelect('user.id as user_id, evaluation.id as evaluation_id, max(userevaluation.grade) as betterGrade, max(userevaluation.dtCreation) as lastEvaluation')
        ->groupBy('user.id, evaluation.id');

      $qb->from('AppBundle:UserEvaluation', 'userevaluation');
      $qb->join("userevaluation.user", "user");
      $qb->join("userevaluation.evaluation", "evaluation");

      if ($user!=null) {
          $qb->andWhere('userevaluation.user = :user')
            ->setParameter('user', $user->getId());
      }

      if ($course!=null) {
          $qb->leftJoin('evaluation.module', 'module');

          $qb->andWhere('module.course = :course')
            ->setParameter('course', $course->getId());
      }

      if ($evaluation!=null) {
          $qb->andWhere('userevaluation.evaluation = :evaluation')
            ->setParameter('evaluation', $evaluation->getId());
      }


      $query = $qb->getQuery();
      return $query->getResult();
      ;
  }

  /**
   *
   *
   */
  public function getTentativas($user, $course)
  {
      $qb = $this->addActiveQuery();
      $qb->join("userEvaluation.evaluation", "evaluation")
        ->join("evaluation.module", "module")
        ->join("module.course", "course");

      $qb->andWhere('course.id = :course_id')
      ->setParameter('course_id', $course->getId());

      $qb->andWhere('userEvaluation.user = :user_id')
      ->setParameter('user_id', $user->getId());


      $query = $qb->getQuery();

      return $query->getResult();
  }

    /**
   *
   *
   */
  public function getApprovedByCrm($client, $course)
  {
      $qb = $this->addActiveQuery();
      $qb->join("userEvaluation.user", "user")
        ->join('AppBundle:Client', 'client', \Doctrine\ORM\Query\Expr\Join::WITH, 'user.id=client.id')
        ->join("userEvaluation.course", "course");

      $qb->andWhere('course.id = :course_id')
      ->setParameter('course_id', $course->getId());
      
      $qb->andWhere('(upper(client.login) = :crmId or
      upper(client.login) like :admId)')
      ->setParameter('crmId', 'CRM'.$client->getCrmForMediacenter())
      ->setParameter('admId', 'ADM00611'.$client->getCrmForMediacenter()."%");
      $qb->andWhere('userEvaluation.approved = 1');


      $query = $qb->getQuery();

      return $query->getResult();
  }
}
