<?php

namespace AppBundle\Repository;

/**
 * UserGroupRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class UserGroupRepository extends \Doctrine\ORM\EntityRepository
{
    /**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null)
    {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('usergroup'))
            ->from('AppBundle:UserGroup', 'usergroup');

        return $qb;
    }
    public function findSecretaria()
    {
        $qb = $this->addActiveQuery();

        $qb->andWhere($qb->expr()->like($qb->expr()->lower('usergroup.itemGroup'), ':group1') ." or ". 
            $qb->expr()->like($qb->expr()->lower('usergroup.itemGroup'), ':group2'))
        ->setParameter(':group1', "%" . strtolower("OUTSYS_PORTALATENDENTE.PERFIL_COMUM") . "%")
        ->setParameter(':group2', "%" . strtolower("CLAUSU.PERFIL_SECRETARIA_MEDICO") . "%");

        return $qb->getQuery()->getOneOrNullResult();
    }
}
