

(function($){

    /**
     * Função para inicializar o indice da tabela de disponibilidade
     */
    function initiateAgency(){
        // Atualiza o indice do prototype com a quantidade de itens disponíveis
        $('#agency-table').attr('data-index-count', $(".agency-item").length);
    }

    /**
     * Método que adiciona um novo dia e horário de disponibilidade.
     */
    function addAgencyItem() {
        var collectionHolder = $('#agency-table');
        var prototype = collectionHolder.attr('data-prototype');
        var count = collectionHolder.attr('data-index-count');
        var newForm = $(prototype.replace(/\_\_name\_\_/g, count));

        collectionHolder.find('tbody').append(newForm);
        collectionHolder.attr('data-index-count', ++count);

        // Adiciona a ação de remover o item
        removeAgencyItem(newForm);

        // Adiciona a validação de licenças escolhidas
        validaAgencyItem(newForm);

        return newForm;
    }

    /**
     * Remove item da tabela de disponibilidade.
     */
    function removeAgencyItem(agencyItem){
        agencyItem.find("a.licences-remove-item").click(function(e){
            e.preventDefault();
            var item = this;
            var title = $(this).data('confirm-title');
            var text = $(this).data('confirm-text');
            var line = $(item).closest('tr.agency-item');
            $(line).remove();

            // Verifica se o botão de adicionar pode ser habilitado novamente
            if($(".agency-item").length < 7){
                $("#agency-add").removeAttr('disabled');
            }

        });
    }

    /**
     * Valida se existem dias repetidos na tabela de disponibilidade
     */
    function validaAgencyItem(agencyItem){
        agencyItem.find(".agency").change(function(e){
            e.preventDefault();
            var agency = $(this);
            var choicedAgency = $(this).val();
            var choicedId = $(this).attr('id');
            $(".agency").each(function( i ){
                if(choicedAgency == $(this).val() && ($(this).attr('id') != choicedId) ){
                    alert ("Este Item já foi selecionado!");
                    agency.val("");
                }
            });
        });
    }

    // Aplica o select2 nos campos definidos
    var applySelect2 = function(){
      $(".select2").select2();
    }

    // Adiciona novo item ao horário
    $("#agency-add").click(function(e){
        e.preventDefault();
        addAgencyItem();
        applySelect2();
    });

    // Seta a função de exclusão nos itens da tabela de disponibilidade
    $("#agency-table tbody").children().each(function() {
        var agencyItem = $(this).closest('tr.agency-item');
        removeAgencyItem(agencyItem);
    });

    // Inicialização das tabelas
    initiateAgency();

    applySelect2();

})(jQuery);
