$(document).ready(function(){

  var courses = coursesDataSet();

  courses.initialize();

  applyTypeahead(courses);
});

function coursesDataSet(){
  var routeTypeaheadUrl = Routing.generate('available_courses_preview_typeahead');
  var courses = new Bloodhound({
   datumTokenizer: Bloodhound.tokenizers.obj.whitespace('title'),
   queryTokenizer: Bloodhound.tokenizers.whitespace,
   limit: 1000,
   remote: {
       url: routeTypeaheadUrl,
       replace: function(url, query) {
           return url + "?q=" + query;
       }
   }
  });
  return courses;
}

function sugestionTemplate(data){
  return '<div class="ProfileCard u-cf Typeahead-suggestion Typeahead-selectable">'+
    '<div class="ProfileCard-details">'+
      '<div class="ProfileCard-realName">'+data.name+'</div>'+
    '</div>'+
  '</div>';
}

function emptyTemplate(){
  return '<div class="ProfileCard u-cf Typeahead-suggestion Typeahead-selectable">'+
    '<div>'+
      'Nenhum vídeo encontrado com os termos'+
    '</div>'+
  '</div>';
}

function selectCourse(course){
  var nestable = $("#nestable").find(".dd-list").first();
  if ( $( "#course-id-"+course.id ).length == 0) {
      var html = '<li class="dd-item" data-id="'+course.id+'" id="course-id-'+course.id+'">'+
        '<div class="dd-handle">'+
          course.name+
        '</div>'+
        '<i class="fa fa-times" aria-hidden="true" onClick="removeItem('+course.id+')"></i>'+
      '</li>';
      nestable.append(html);
      updateOutput($('#nestable').data('output', $('#nestable-output')));
  }

}

var updateOutput = function (e) {
    var list = e.length ? e : $(e.target),
        output = $('#nestable-output');
    if (window.JSON) {
        $("#learningtrail_courses").val(window.JSON.stringify(list.nestable('serialize')));
    }
};

function applyTypeahead(courses){
  $('#course-query').typeahead(null, {
       name: 'courses',
       displayKey: 'title',
       limit: 1000,
       source: courses.ttAdapter(),
       templates: {
         suggestion: function(data){
             return sugestionTemplate(data);
         },
         empty: function(data){
             return emptyTemplate();
         },
       }
  }).on('typeahead:selected', function(event, selection) {
      selectCourse(selection);
      $(this).typeahead('val', '');
  });
}
