$(document).ready(function () {

    // Inicialização das tabelas
    initiateMacroItens();

    // Adiciona novo item à tabela de serviços
    $("#item-add").click(function (e) {
        e.preventDefault();
        var totalAdd = $('.itens-qtd-add').find(":selected").val();
        for (i = 0; i < totalAdd; i++) {
            addMacroItem();
        }
    });

    // Seta a função de exclusão nos itens da tabela de disponibilidade
    $("#macroitens-table tbody").children().each(function () {
        var macroitensItem = $(this).closest('tr.macroitens-item');
        removeMacroItens(macroitensItem);
        validaMacroItem(macroitensItem);
    });
});


/**
 * Função para inicializar o indice da tabela de serviços
 */
function initiateMacroItens() {
    // Atualiza o indice do prototype com a quantidade de itens disponíveis
    $('#macroitens-table').attr('data-index-count', $(".macroitens-item").length);
}

/**
 * Método que adiciona um novo lote pago.
 */
function addMacroItem() {
    var collectionHolder = $('#macroitens-table');
    var prototype = collectionHolder.attr('data-prototype');
    var count = collectionHolder.attr('data-index-count');
    var newForm = $(prototype.replace(/\_\_name\_\_/g, count));

    collectionHolder.find('tbody').append(newForm);
    collectionHolder.attr('data-index-count', ++count);

    // Adiciona a ação de remover o item
    removeMacroItens(newForm);

    return newForm;
}

/**
 * Remove item da tabela de disponibilidade.
 */
function removeMacroItens(macroitensItem) {
    macroitensItem.find("a.macroitens-remove-item").click(function (e) {
        e.preventDefault();
        var item = this;
        var line = $(item).closest('tr.macroitens-item');
        $(line).remove();

    });
}

/**
 * Valida se existem dias repetidos na tabela de disponibilidade
 */
function validaMacroItem(macroitensItem) {
    macroitensItem.find(".correct-answer").click(function (e) {
        var idEscolhido = $(this).attr('id');
        if ($(this).prop('checked')) {
            $(".correct-answer").each(function (i) {
                if ($(this).attr('id') != idEscolhido) {
                    $(this).prop("checked", false);
                }
            });
        }
    });
}
