$(document).ready(function () {

    // Inicialização das tabelas
    initiateMacroItens();

    // Adiciona novo item à tabela de serviços
    $(".item-add").click(function (e) {
        e.preventDefault();
        // console.log($(this).parent('.section-qtd-add').closest('.itens-qtd-add'))
        var totalAdd = $(this).parent().parent().find('.itens-qtd-add').find(":selected").val();
        // var totalAdd = $('.itens-qtd-add').find(":selected").val();
        for (i = 0; i < totalAdd; i++) {
            // console.log($(this).parent().parent().parent().find('.macroitens-table'))
            var tableMacro = $(this).parent().parent().parent().find('.macroitens-table')
            addMacroItem(tableMacro);
        }
    });

    // Seta a função de exclusão nos itens da tabela de disponibilidade
    $(".macroitens-table tbody").children().each(function () {
        var macroitensItem = $(this).closest('tr.macroitens-item');
        removeMacroItens(macroitensItem);
        validaMacroItem(macroitensItem);
    });
});


/**
 * Função para inicializar o indice da tabela de serviços
 */
function initiateMacroItens() {
    // Atualiza o indice do prototype com a quantidade de itens disponíveis

    $('body').find('.macroitens-table').each(function () {
        $(this).attr('data-index-count', $(".macroitens-item").length);
    });
}

function addMacroItem(collectionHolder) {
    // var collectionHolder = $('#macroitens-table');
    var prototype = collectionHolder.attr('data-prototype');
    var count = collectionHolder.attr('data-index-count');
    var newForm = $(prototype.replace(/\_\_name\_\_/g, count));

    collectionHolder.find('tbody').append(newForm);
    collectionHolder.attr('data-index-count', ++count);

    // Adiciona a ação de remover o item
    removeMacroItens(newForm);

    // Adiciona a validação de licenças escolhidas
    validaMacroItem(newForm);

    return newForm;
}

/**
 * Remove item da tabela de disponibilidade.
 */
function removeMacroItens(macroitensItem) {
    macroitensItem.find("a.macroitens-remove-item").click(function (e) {
        e.preventDefault();
        var item = this;
        var line = $(item).closest('tr.macroitens-item');
        $(line).remove();

    });
}

/**
 * Valida se existem dias repetidos na tabela de disponibilidade
 */
function validaMacroItem(macroitensItem) {
    macroitensItem.find(".macro-item-select").change(function (e) {
        e.preventDefault();
        var macroItem = $(this);
        var choicedOption = $(this).val();
        var choicedId = $(this).attr('id');
        $(".macro-item-select").each(function( i ){
            if(choicedOption == $(this).val() && ($(this).attr('id') != choicedId) ){
                alert ("Esta permissão já foi selecionada!");
                macroItem.val("");
            }
        });
    });
}
