$(document).ready(function(){
  validateOptions($('#course_autoInscription'));
  var idVideo = $("#box-video").data("id-video");
  var routeTypeaheadUrl = Routing.generate('available_videos_preview_typeahead');
  var videos = new Bloodhound({
   datumTokenizer: Bloodhound.tokenizers.obj.whitespace('title'),
   queryTokenizer: Bloodhound.tokenizers.whitespace,
   limit: 1000,
   remote: {
       url: routeTypeaheadUrl,
       replace: function(url, query) {
           return url + "?q=" + query;
       }
   }
  });
  videos.initialize();
  $('#video-query').typeahead(null, {
       name: 'videos',
       displayKey: 'title',
       limit: 1000,
       source: videos.ttAdapter(),
       templates: {
         suggestion: function(data){
               return '<div class="ProfileCard u-cf Typeahead-suggestion Typeahead-selectable">'+
                 '<img class="ProfileCard-avatar" src="'+data.thumbs[0].url+'">'+
                 '<div class="ProfileCard-details">'+
                   '<div class="ProfileCard-realName">'+data.title+'</div>'+
                   '<div class="ProfileCard-screenName"></div>'+
                   '<div class="ProfileCard-description">'+(data.shortDescription==null?"":data.shortDescription)+'</div>'+
                 '</div>'+
               '</div>';
         },
         empty: [
            '<div class="ProfileCard u-cf Typeahead-suggestion Typeahead-selectable">'+
              '<div>'+
                'Nenhum vídeo encontrado com os termos'+
              '</div>'+
            '</div>'
          ].join('\n'),
       }
   }).on('typeahead:selected', function(event, selection) {
      $('#'+idVideo).val(selection.id);
      $(".video-image").attr("src", selection.thumbs[0].url);
      $(".video-title").html(selection.title);
      $("#box-video").show();

      $(this).typeahead('val', '');;
    });

    // Adiciona novo item à tabela de serviços
    $("#remove-video").click(function(e){
      $("#box-video").hide();
      $('#'+idVideo).val("");
    });

    //Aplica o date picker
    $('.date-picker').datepicker({
        format: 'dd/mm/yyyy',
    });

    var course_category = $('#course_category').val();

    if ($('#course_modality').val() == 'Presencial') {
        $('.ead-course').addClass('hidden');
        $("#course_category").html(presencialOptions);
    }else{
      $("#course_category").html(eadOptions);
    }

    if(course_category){
      $("#course_category").val(course_category);
    }

    $('#course_modality').change(function() {
        if($(this).val() == 'Presencial') {
          $('.ead-course').addClass('hidden');
          $("#course_category").html(presencialOptions);
        } else {
          $('.ead-course').removeClass('hidden');
          $("#course_category").html(eadOptions);
        }

        if(course_category){
          $("#course_category").val(course_category);
        }
    });

    // $('#submitCourse').click(function(e) {
    //   e.preventDefault();
    //   var options = $("#course_autoInscription").val();
    //   if(options.includes("Nenhum") && options.includes("Todos")){
    //     alert("Para a Auto inscrição você não pode selecionar a opção Nenhum Perfil e Todos ao mesmo tempo.");
    //   }else{
    //     $('.formCourse').submit();
    //   }
    // });

    $('#course_autoInscription').change(function(e) {
      e.preventDefault();
      validateOptions($(this));
    });

});

function validateOptions(dropDown){
      var selected = dropDown.val();
      var options = $("#course_autoInscription").find("option");
      if(selected != null && selected.includes("Nenhum")){
        // console.log("Opção nenhum selecionado");
        options.each(function(){
          if($( this ).val() != "Nenhum"){
            // $( this ).attr('disabled','disabled');
            if($( this ).is(':selected')){
              $( this ).removeAttr("selected")
            }
          }
        });
        // alert("Para a Auto inscrição você não pode selecionar a opção Nenhum Perfil e Todos ao mesmo tempo.");

      }else if(selected != null && selected.includes("Todos")){
        // console.log("Opção todos selecionado");
        options.each(function(){
          if($( this ).val() != "Todos"){
            // $( this ).attr('disabled','disabled');
            if($( this ).is(':selected')){
              $( this ).removeAttr("selected")
            }
          }
        });
        // alert("Para a Auto inscrição você não pode selecionar a opção Nenhum Perfil e Todos ao mesmo tempo.");

      }else{
        // console.log("Todas as opções liberadas");
        options.each(function(){
          // $( this ).removeAttr('disabled');
        });
      }
}

function copyLinkCourse() {

    var el = document.createElement('input');
    el.value = document.querySelector('#urlCourseLMS').innerText
    el.style.position = 'absolute';
    el.style.left = '-9999px';
    document.body.appendChild(el);
    el.select();
    document.execCommand('copy');
    document.body.removeChild(el);
}