$(document).ready(function(){
    //Aplica o date picker
    $('.date-picker').datepicker({
        format: 'dd/mm/yyyy',
    });

    $('.date-time-picker').datetimepicker({
        format: 'DD/MM/YYYY HH:mm',
        // debug: true,
        widgetPositioning: {
            horizontal: 'auto',
            vertical: 'bottom'
        }
    });

    $('.course-class-begin').on('dp.change', function (e) {
        $('.course-class-end').data("DateTimePicker").minDate(e.date);
        var courseClassBeginFormated = formatDate($(this).val(), 'pt_br');
        var courseClassBegin = formatDate($(this).val());
        
        $('.event-class-begin').each(function() {
            var eventClassBegin = formatDate($(this).val(), 'pt_br');
            var diff = new Date(eventClassBegin) - new Date(courseClassBeginFormated);
            var days = diff / 1000 / 60 / 60 / 24;
            if(days < 0){
                $(this).val("");
            }
            $(this).datepicker('setStartDate', courseClassBegin);
            $(this).datepicker('setEndDate', formatDate($('.course-class-end').val()));
        });
        $('.event-class-end').each(function() {
            var eventClassEnd = formatDate($(this).val(), 'pt_br');
            var diff = new Date(eventClassEnd) - new Date(courseClassBeginFormated);
            var days = diff / 1000 / 60 / 60 / 24;
            if(days < 0){
                $(this).val("");
            }
            $(this).datepicker('setStartDate', courseClassBegin);
            $(this).datepicker('setEndDate', formatDate($('.course-class-end').val()));
        });
    });

    $('.course-class-end').on('dp.change', function (e) {
        $('.course-class-begin').data("DateTimePicker").maxDate(e.date);
        // $(".event-class-end").datepicker('setEndDate', $(this).val());
        var courseClassEndFormated = formatDate($(this).val(), 'pt_br');
        var courseClassEnd = formatDate($(this).val());

        $('.event-class-begin').each(function() {
            var eventClassBegin = formatDate($(this).val(), 'pt_br');
            var diff = new Date(eventClassBegin) - new Date(courseClassEndFormated);
            var days = diff / 1000 / 60 / 60 / 24;
            if(days > 0){
                $(this).val("");
            }
            $(this).datepicker('setStartDate', formatDate($('.course-class-begin').val()));
            $(this).datepicker('setEndDate', courseClassEnd);
        });

        $('.event-class-end').each(function() {
            var eventClassEnd = formatDate($(this).val(),'pt_br');
            var diff = new Date(eventClassEnd) - new Date(courseClassEndFormated);
            var days = diff / 1000 / 60 / 60 / 24;
            if(days > 0){
                $(this).val("");
            }
            $(this).datepicker('setStartDate', formatDate($('.course-class-begin').val()));
            $(this).datepicker('setEndDate', courseClassEnd);
        });
    });
    $('.course-class-begin').data("DateTimePicker").maxDate($('.course-class-end').data("DateTimePicker").date());
    $('.course-class-end').data("DateTimePicker").minDate($(".course-class-begin").data("DateTimePicker").date());
    $(".event-class-begin").datepicker('setStartDate', formatDate($(".course-class-begin").val()));
    $(".event-class-begin").datepicker('setEndDate', formatDate($(".course-class-end").val()));
    $(".event-class-end").datepicker('setStartDate', formatDate($(".course-class-begin").val()));
    $(".event-class-end").datepicker('setEndDate', formatDate($(".course-class-end").val()));

    // Inicialização das tabelas
    initiateEventClass();

    // Adiciona novo item à tabela de serviços
    $("#item-add").click(function(e){
        e.preventDefault();
        addEventClass();
    });

    // Seta a função de exclusão nos itens da tabela de disponibilidade
    $("#eventClass-table tbody").children().each(function() {
        var eventClassItem = $(this).closest('tr.eventClass-item');
        removeEventClass(eventClassItem);
    });


    $(".btn-success").click(function(e){
        if($(".eventClass-item").length > 0){
            $(".courseClassForm").submit();
        }else{
            e.preventDefault();
            alert("Você deve cadastrar pelo menos um evento!");
        }
    });
});

/**
 * Função para inicializar o indice da tabela de serviços
 */
function initiateEventClass(){
    // Atualiza o indice do prototype com a quantidade de itens disponíveis
    $('#eventClass-table').attr('data-index-count', $(".eventClass-item").length);
}

/**
 * Método que adiciona um novo lote pago.
 */
function addEventClass() {
    var collectionHolder = $('#eventClass-table');
    var prototype = collectionHolder.attr('data-prototype');
    var count = collectionHolder.attr('data-index-count');
    var newForm = $(prototype.replace(/\_\_name\_\_/g, count));

    collectionHolder.find('tbody').append(newForm);
    collectionHolder.attr('data-index-count', ++count);

    // Adiciona a ação de remover o item
    removeEventClass(newForm);
    addDatePicker(newForm);

    // Adiciona a validação de licenças escolhidas
    validaEventDescription(newForm);

    return newForm;
}

/**
 * Remove item da tabela de disponibilidade.
 */
function removeEventClass(eventClassItem){
    eventClassItem.find("a.eventClass-remove-item").click(function(e){
        e.preventDefault();
        var item = this;
        var title = $(this).data('confirm-title');
        var text = $(this).data('confirm-text');
        var line = $(item).closest('tr.eventClass-item');
        $(line).remove();
    });
}

/**
 * Valida se existem dias repetidos na tabela de disponibilidade
 */
function validaEventDescription(item){
    item.find(".event-description").change(function(e){
        e.preventDefault();
        var event = $(this);
        var choicedDescription = $(this).val();
        var choicedId = $(this).attr('id');
        $(".event-description").each(function( i ){
            if(choicedDescription.toUpperCase() == $(this).val().toUpperCase() && ($(this).attr('id') != choicedId) ){
                alert ("Essa descrição já foi definida para essa turma");
                event.val("");
            }
        });
    });
}

/**
 * Remove item da tabela de disponibilidade.
 */
function addDatePicker(eventClassItem){
    eventClassItem.find(".date-picker").datepicker({
        format: 'dd/mm/yyyy',
    });

    eventClassItem.find(".event-class-begin").datepicker('setStartDate', formatDate($(".course-class-begin").val()));
    eventClassItem.find(".event-class-begin").datepicker('setEndDate', formatDate($(".course-class-end").val()));
    eventClassItem.find(".event-class-end").datepicker('setStartDate', formatDate($(".course-class-begin").val()));
    eventClassItem.find(".event-class-end").datepicker('setEndDate', formatDate($(".course-class-end").val()));
}

function formatDate(date, type){
    if(date){
        if(type == "pt_br"){
            var dateArray = date.split(" ");
            var dateArray = dateArray[0].split("/");
            return dateArray[1]+"/"+dateArray[0]+"/"+dateArray[2];
        }else{
            var dateArray = date.split(" ");
            var dateArray = dateArray[0].split("/");
            return dateArray[0]+"/"+dateArray[1]+"/"+dateArray[2];
        }
    }
    return "";
}