$(document).ready(function(){
    //Aplica o date picker
    $('.date-picker').datepicker({
        format: 'dd/mm/yyyy',
    });

    $('#iqa_cicle_beginDate').datepicker().on('changeDate', function (ev) {
        $('#iqa_cicle_endDate').datepicker('setStartDate', $(this).val());
        var courseClassBeginFormated = formatDate($(this).val());
        var courseClassEndFormated = formatDate($('#iqa_cicle_endDate').val());

        var diff = new Date(courseClassEndFormated) - new Date(courseClassBeginFormated);
        var days = diff / 1000 / 60 / 60 / 24;
        if(days < 0){
            $(this).val("");
        }
    });

    $('#iqa_cicle_endDate').datepicker().on('changeDate', function (ev) {
        $('#iqa_cicle_beginDate').datepicker('setEndDate', $(this).val());
        var courseClassBeginFormated = formatDate($(this).val());
        var courseClassEndFormated = formatDate($('#iqa_cicle_beginDate').val());

        var diff = new Date(courseClassEndFormated) - new Date(courseClassBeginFormated);
        var days = diff / 1000 / 60 / 60 / 24;
        if(days > 0){
            $(this).val("");
        }
    });

    $('#iqa_cicle_beginDate').datepicker('setEndDate', $("#iqa_cicle_endDate").val());
    $('#iqa_cicle_endDate').datepicker('setStartDate', $("#iqa_cicle_beginDate").val());

    $('.select2').select2();

    $("form").submit( function(e) {

        if($(".iqamidias-item").length==0){
            e.preventDefault();
            alert("Você deve selecionar pelo menos uma mídia para o cadastro do cíclo.");
        }
	});

    // Inicialização das tabelas
    initiateIqaMidias();

    // Adiciona novo item à tabela de serviços
    $("#item-add").click(function(e){
        e.preventDefault();
        var totalAdd = $('.itens-qtd-add').find(":selected").val();
        for (i = 0; i < totalAdd; i++) {
            addQuestionItem();
        }
    });

    // Seta a função de exclusão nos itens da tabela de disponibilidade
    $("#iqamidias-table tbody").children().each(function() {
        var iqamidiasItem = $(this).closest('tr.iqamidias-item');
        removeIqaMidias(iqamidiasItem);
        validaMidiaSelection(iqamidiasItem);
    });
});


function formatDate(date){
    if(date){
        var dateArray = date.split("/");
        return dateArray[1]+"/"+dateArray[0]+"/"+dateArray[2];
    }
    return "";
}


/**
 * Função para inicializar o indice da tabela de serviços
 */
 function initiateIqaMidias(){
    // Atualiza o indice do prototype com a quantidade de itens disponíveis
    $('#iqamidias-table').attr('data-index-count', $(".iqamidias-item").length);
}

/**
 * Método que adiciona um novo lote pago.
 */
function addQuestionItem() {
    var collectionHolder = $('#iqamidias-table');
    var prototype = collectionHolder.attr('data-prototype');
    var count = collectionHolder.attr('data-index-count');
    var newForm = $(prototype.replace(/\_\_name\_\_/g, count));

    collectionHolder.find('tbody').append(newForm);
    collectionHolder.attr('data-index-count', ++count);

    // Adiciona a ação de remover o item
    removeIqaMidias(newForm);

    $('.select2').select2();

    // Adiciona a validação de licenças escolhidas
    validaMidiaSelection(newForm);

    return newForm;
}

/**
 * Remove item da tabela de disponibilidade.
 */
function removeIqaMidias(iqamidiasItem){
    iqamidiasItem.find("a.iqamidias-remove-item").click(function(e){
        e.preventDefault();
        var item = this;
        var title = $(this).data('confirm-title');
        var text = $(this).data('confirm-text');
        var line = $(item).closest('tr.iqamidias-item');
        $(line).remove();

    });
}

/**
 * Valida se existem dias repetidos na tabela de disponibilidade
 */
function validaMidiaSelection(iqamidiasItem){
    iqamidiasItem.find(".midia-name").change(function(e){
        e.preventDefault();
        var event = $(this);
        var choicedVal = $(this).val();
        var choicedId = $(this).attr('id');
        var choicedType = $(this).find('option:selected').data('midia-type');
        var identification = $(this).data("identification");
        $("#"+identification+"_midiaTypeTemp").val(choicedType);
        $("#"+identification+"_type_description").html(choicedType);
        if(choicedVal!=""){
            $(".midia-name").each(function( i ){
                if(choicedVal == $(this).val() && ($(this).attr('id') != choicedId) && ($(this).find('option:selected').data('midia-type') == choicedType || $(this).data('midia-type') == choicedType) ){
                    alert ("Essa Mídia já foi selecionada para este ciclo");
                    event.val("");
                    event.trigger("change");
                    $(identification+"_midiaTypeTemp").val("");
                    $("#"+identification+"_type_description").html("");
                }
            });
        }
    });
}