
var UINestable = function () {
	"use strict";
    //function to initiate jquery.nestable
    var updateOutput = function (e) {
        var list = e.length ? e : $(e.target),
            output = $('#nestable-output');
        if (window.JSON) {
            //console.log(list.nestable('serialize'));
            //console.log(window.JSON.stringify(list.nestable('serialize')));
            $("#learningtrail_courses").val(window.JSON.stringify(list.nestable('serialize')));
        } else {
            output.text('JSON browser support required for this demo.');
        }
    };
    var runNestable = function () {
        // activate Nestable for list 1
        $('#nestable').nestable({
            group: 1
        }).on('change', updateOutput);
        // output initial serialised data
        updateOutput($('#nestable').data('output', $('#nestable-output')));
    };
    return {
        //main function to initiate template pages
        init: function () {
            runNestable();
        }
    };
}();

/*var listify = function(strarr) {
  var l = $("<ol>").addClass("dd-list");
  $.each(strarr, function(i, v) {
    var url = Routing.generate('get_course_by_id');
    var c = $("<li>").addClass("dd-item").attr("data-id", v["id"]).attr("id", 'course-id-'+v["id"]);
    $.get( url, {courseId: v["id"]}, function( data ) {
        var h = $("<div>").addClass("dd-handle").text(data.data.name);
        c.append(h);
        c.append('<i class="fa fa-times" aria-hidden="true" onClick="removeItem('+v["id"]+')"></i>');
        l.append(c);
        if (!!v["children"])
          c.append(listify(v["children"]));
    });
  });
  return l;
}*/

var buildElement = function(nameEl, addClass){
    var el = document.createElement(nameEl);
    if (addClass) el.setAttribute('class', addClass);
    return el;
}

var buildItemDDList = function(itemData){
    var el = buildElement('li', 'dd-item');
    el.setAttribute('data-id', itemData.id);
    el.setAttribute('id', 'course-id-'+itemData.id);

    return el;
}

var removeItem = function(id){
	$("#course-id-"+id).remove();
    updateOutput($('#nestable').data('output', $('#nestable-output')));
}

var createElRemoveItem = function(itemData){
    var el = document.createElement('i');
    el.setAttribute('class', 'fa fa-times');
    el.setAttribute('aria-hidden', 'true');
    el.addEventListener('click', function(){
        var itemDDLiEl = document.querySelector('#course-id-'+itemData.id);
        itemDDLiEl.remove();
        updateOutput($('#nestable').data('output', $('#nestable-output')));
    });
    return el;
}

var listify = function(dataList){
    var ddListElement = buildElement('ol', 'dd-list');
    dataList.map(function(itemData, index){
        var itemDDLiEl = buildItemDDList(itemData);
        var contentItemDDEl = buildElement('div', 'dd-handle');
        var iconRemoveEl = createElRemoveItem(itemData);
        contentItemDDEl.innerHTML = itemData.name;
        itemDDLiEl.appendChild(contentItemDDEl);
        itemDDLiEl.appendChild(iconRemoveEl);
        ddListElement.appendChild(itemDDLiEl);
        if (!!itemData.children){
            itemDDLiEl.appendChild(listify(itemData.children));
        }
    });

    return ddListElement;
}

jQuery(document).ready(function() {
  UINestable.init();
  var tarr = $("#jsonCourses").val();
  if(tarr!=null && tarr!=""){
      tarr = JSON.parse(tarr);
      /*var list = listify(tarr);
      $('#nestable').append(list);
      $("#learningtrail_courses").val($("#jsonCourses").val());*/

      if (dataCourses){
          var list = listify(dataCourses);
          $('#nestable').append(list);
          $("#learningtrail_courses").val($("#jsonCourses").val());
      }
  }
  if($("#learningtrail_public").is(":checked")){
      // alert("Está marcado");
      $('#management-section').hide();
  }else {
      // alert("Não marcado");
      $('#management-section').show();
  }
  $("#learningtrail_public").click(function(){
      if($(this).is(":checked")){
          $('#agency-table').attr('data-index-count', 0);
          $('#agency-table tbody').html("");
          $('#management-section').hide();
      }else{
          // Atualiza o indice do prototype com a quantidade de itens disponíveis
          $('#management-section').show();

      }

  });

});
