'use strict';

/* Controllers */
var app = angular.module('enlab.controllers.lesson', []);

app.controller('ShowController', ['$scope', '$http', '$interval', function ($scope, $http, $interval) {


	$scope.comments = new Array();
	$scope.inicio = function(lesson)
	{
		$scope.lesson = lesson;
		atualizarMensagens();
		$interval(atualizarMensagens, 30000);
	}

	function atualizarMensagens()
	{
		var route = Routing.generate('comment_index', {lessonId: $scope.lesson});

		$http({
		    url: route,
		    method: "GET",
		 }).then(function successCallback(response) {
		 	if (response.data.responseCode == 200){
		 		$scope.comments = response.data.results;
		 	} else {
		 		console.log(response.data.results);
		 	}
		 });
	}

	$scope.salvar = function()
	{
		$scope.comment = {
			lesson: $scope.lesson,
			message: $scope.mensagem
		};

        var routeSave = Routing.generate('comment_save');

		$http({
		    url: routeSave,
		    method: "POST",
		    data: {comment: $scope.comment},
		 }).then(function successCallback(response) {
		 	$scope.comments = response.data.results;
		 }, function errorCallback(response) {
		});
	}

	var valInicial = 5, //Valor inicial a ser carregado
	    valAtualiza = 5, //Quantidade a ser atualizada a cada clique
	    valAtual = valInicial,
	    totalItem = $scope.comments.length; //length total da lista de dados que você possui

	$scope.botaoAtivo = true; //Mostra o botão por padrão
	$scope.limiteValor = valInicial; //Usado no DOM para limitar exibição na tabela

	function loadMore() {
	    valAtual += valAtualiza;
	    $scope.limiteValor = valAtual;
	    if (valAtual >= totalItem) {
	        $scope.botaoAtivo = false; //Desativa o botao de carregar mais
	        return;
	    };
	};

	$scope.carregaMais = function() { //Chamando a função de 'carregar mais' com clique de botão
	    loadMore();
	};

}]);


angular.module('enlabApp').requires.push('enlab.controllers.lesson');