$(document).ready(function() {

    // Inicialização das tabelas
    initiateQuestionItens();

    $(".sortable").sortable({
        opacity: 0.3, cursor: 'move', update: function () {
            // var order = $(this).sortable("serialize");
            ordenateItemSorteble();
        }
    });

    // Adiciona novo item à tabela de serviços
    $("#item-add").click(function(e){
        e.preventDefault();
        var totalAdd = $('.itens-qtd-add').find(":selected").val();
        for (i = 0; i < totalAdd; i++) {
            addQuestionItem();
        }
        ordenateItemSorteble();
    });

    // Seta a função de exclusão nos itens da tabela de disponibilidade
    $("#surveyitens-table tbody").children().each(function() {
        var surveyitensItem = $(this).closest('tr.surveyitens-item');
        removeQuestionItens(surveyitensItem);
        validaQuestionItem(surveyitensItem);
    });

});

function ordenateItemSorteble() {
    var $elTableItens = $('#surveyitens-table')
    var $elItensSortable = $elTableItens.find('tr.surveyitens-item')
    var quantItensSortable = $elItensSortable.length
    // var widget = $(this).sortable("widget")

    var updateAttrNameItemList = function (el, position) {
        var nameItem = el.attr('name')
        var regex = /[0-9]/
        nameItem = nameItem.replace(regex, position)
        el.attr('name', nameItem)
    }

    $elItensSortable.each(function (index) {
        var $elNameItem = $(this).find('input.survery_item_name')
        var $elPositionItem = $(this).find('input.survery_item_position')
        var $elShowCommentItem = $(this).find('input.survery_item_show_comment')
        $elPositionItem.attr('value', index)
        updateAttrNameItemList($elNameItem, index)
        updateAttrNameItemList($elPositionItem, index)
        updateAttrNameItemList($elShowCommentItem, index)
    })
}


/**
 * Função para inicializar o indice da tabela de serviços
 */
function initiateQuestionItens(){
    // Atualiza o indice do prototype com a quantidade de itens disponíveis
    $('#surveyitens-table').attr('data-index-count', $(".surveyitens-item").length);
}

/**
 * Método que adiciona um novo lote pago.
 */
function addQuestionItem() {
    var collectionHolder = $('#surveyitens-table');
    var prototype = collectionHolder.attr('data-prototype');
    var count = collectionHolder.attr('data-index-count');
    prototype = prototype.replace(/\_\_name\_\_/g, count)
    prototype = prototype.replace(/\_\_order\_\_/g, count)
    var newForm = $(prototype);

    collectionHolder.find('tbody').append(newForm);
    collectionHolder.attr('data-index-count', ++count);

    // Adiciona a ação de remover o item
    removeQuestionItens(newForm);

    return newForm;
}

/**
 * Remove item da tabela de disponibilidade.
 */
function removeQuestionItens(surveyitensItem){
    surveyitensItem.find("a.surveyitens-remove-item").click(function(e){
        e.preventDefault();
        var item = this;
        var title = $(this).data('confirm-title');
        var text = $(this).data('confirm-text');
        var line = $(item).closest('tr.surveyitens-item');
        $(line).remove();
        ordenateItemSorteble();
    });
}

/**
 * Valida se existem dias repetidos na tabela de disponibilidade
 */
function validaQuestionItem(surveyitensItem){
    surveyitensItem.find(".correct-answer").click(function(e){
        var idEscolhido = $(this).attr('id');
        if($(this).prop('checked')){
          $(".correct-answer").each(function( i ){
              if($(this).attr('id') != idEscolhido){
                  $(this).prop( "checked", false );
              }
          });
        }
    });
}
