
(function() {

    function hideButtonPrevSurveyItem() {
        if ($('.survey-answer-item.showIn').attr('data-order') == "1") {
            $('.previous-survey-answer').addClass('hidden');
        }

    }

    function hideButtonNextSurveyItem() {
        var quantSurveyItens = document.querySelectorAll('.survey-answer-item').length
        if ($('.survey-answer-item.showIn').attr('data-order') == quantSurveyItens) {
            $('.next-survey-answer').addClass('hidden');
        }
    }

    function nextSurveyAnswer(){
        if ($('.previous-survey-answer').hasClass('hidden')) {
            $('.previous-survey-answer').removeClass('hidden');
        }
        var surveyItemNext = $('.survey-answer-item.showIn').next('.survey-answer-item.hidden');
        $('.survey-answer-item.showIn').removeClass('showIn animated slideInRight').addClass('hidden');
        surveyItemNext.removeClass('hidden').addClass('showIn animated slideInRight');
        // hideButtonNextSurveyItem()
    }

    function previousSurveyAnswer() {
        if ($('.next-survey-answer').hasClass('hidden')) {
            $('.next-survey-answer').removeClass('hidden');
        }
        var surveyItemPrev = $('.survey-answer-item.showIn').prev('.survey-answer-item.hidden');
        $('.survey-answer-item.showIn').removeClass('showIn animated slideInLeft').addClass('hidden');
        surveyItemPrev.removeClass('hidden').addClass('showIn animated slideInLeft');
        hideButtonPrevSurveyItem()
    }

    var surveyItemCurrent = {};
    
    var attachmentEvents = function () {
        $(".score").click(function () {

            var elCommentSurveyItem = $(this).parents('.score-survey-item').siblings('.answer-survey-item')

            var surveyItem = $(this).data("survey-item");
            var score = $(this).data("score");
            var courseId = $(this).data("course")

            $(".score-item-" + surveyItem).each(function (index) {
                $(this).removeClass("box-selected");
            });

            $(this).addClass("box-selected");
            $("#survey_item_" + surveyItem).val(score);

            if (elCommentSurveyItem.length > 0) {
                var rowScoreItem = $(this).parents('.score-survey-item')
                var rowAnswerScore = rowScoreItem.siblings('.answer-survey-item')

                rowScoreItem.addClass('hidden')
                rowAnswerScore.removeClass('hidden')
            }

            surveyItemCurrent = {
                survey_item_id: surveyItem,
                survey_answer_value: score,
                survey_answer_comment: '',
                course: courseId
            }

        });

        $('.back-survey-score').click(function (e) {
            e.preventDefault();
            var rowAnswerScore = $(this).parents('.answer-survey-item')
            var rowScoreItem = rowAnswerScore.siblings('.score-survey-item')

            rowAnswerScore.addClass('hidden');
            rowScoreItem.removeClass('hidden');
        })

        $('.btn-submit').click(function (e) {
            e.preventDefault();
            var scores = document.querySelectorAll('input[type="hidden"]');
            var valid = true;
            scores.forEach(function (elScore) {
                if (!elScore.value) {
                    valid = false;
                }
            })
            if (valid) {
                $("#survey").submit();
            } else {
                alert("Selecione todas as opções");
            }
        })

        // $('.previous-survey-answer').click(function (e) {
        //     e.preventDefault();
        //     previousSurveyAnswer();
        // });

        $('.next-survey-answer').click(function (e) {
            e.preventDefault();

            var selectedAnswerScore = $('.survey-answer-item.showIn').find('.survey_answer_score').val();
            var elCommentSurveyItem = $('.survey-answer-item.showIn').find('.answer-survey-item').find('textarea')
            if (elCommentSurveyItem.length > 0) {
                surveyItemCurrent.survey_answer_comment = elCommentSurveyItem.val()
            }

            var currentSurveyAnswer = parseInt($('.survey-answer-item.showIn').data('order'))
            var lastSurveyAnswer = parseInt($('.survey-answer-item.showIn').data('item-last'))

            if ((currentSurveyAnswer + 1) == lastSurveyAnswer) {
                $('.next-survey-answer').text('Enviar')
            }

            
            if(selectedAnswerScore == ""){
                $(".alert-message").html('<div class="alert alert-danger alert-survey">'+
                    '<a href="#" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>'+
                    'Você deve escolher um item da escala antes de prosseguir!'+
                    '</div>'
                );
            }else{
                $(".alert-message").html("");
                if (currentSurveyAnswer == lastSurveyAnswer) {
                    $.LoadingOverlay("show");
                } else {
                    nextSurveyAnswer();
                }

                var routeUrl = Routing.generate('survey_item_answer_save');
                $.post(routeUrl, surveyItemCurrent,
                    function (data) {
                        $.LoadingOverlay("hide");
                        var routeUrlCertificate = Routing.generate('home_certificate') + '?finish=survey_answer&courseId='+data.courseId
                        if (data.responseCode == 200 && data.data == 'done') {
                            if (currentSurveyAnswer == lastSurveyAnswer) {
                                window.location.href = routeUrlCertificate
                            }
                        }
                        else if(data.responseCode == 500) {
                            console.log(data.data.msg)
                            if (currentSurveyAnswer == lastSurveyAnswer) {
                                alert('Houve um erro inesperado. Tente novamente mais tarde');
                                setTimeout(function() {
                                    window.location.href = routeUrlCertificate
                                }, 2000)                            
                            }
                        }
                    }
                );
            }
        });
    }

    var init = function () {
        attachmentEvents()
        hideButtonPrevSurveyItem()
    }

    init();

})();