(function( $ ) {


	$("input.telefone")
	        .mask("(99) 9999-9999?9")
	        .focusout(function (event) {
	            var target, phone, element;
	            target = (event.currentTarget) ? event.currentTarget : event.srcElement;
	            phone = target.value.replace(/\D/g, '');
	            element = $(target);
	            element.unmask();
	            if(phone.length > 10) {
	                element.mask("(99) 99999-999?9");
	            } else {
	                element.mask("(99) 9999-9999?9");
	            }
	        });

	$("input.cep").mask("99999-999");

	$("input.cpf").mask("999.999.999-99")
			.focusout(function (event) {
				var target, cpf, element;
				target = (event.currentTarget) ? event.currentTarget : event.srcElement;
				cpf = target.value.replace(/\D/g, '');
				element = $(target);
				if(cpf == ""){
					return true;
				}
				// Elimina CPFs invalidos conhecidos
    		if (cpf.length != 11 ||
        cpf == "00000000000" ||
        cpf == "11111111111" ||
        cpf == "22222222222" ||
        cpf == "33333333333" ||
        cpf == "44444444444" ||
        cpf == "55555555555" ||
        cpf == "66666666666" ||
        cpf == "77777777777" ||
        cpf == "88888888888" ||
        cpf == "99999999999"){
					alert("CPF inválido");
					element.focus();
					return false;
				}
		    // Valida 1o digito
		    add = 0;
		    for (i=0; i < 9; i ++)
		        add += parseInt(cpf.charAt(i)) * (10 - i);
		        rev = 11 - (add % 11);
		        if (rev == 10 || rev == 11)
		            rev = 0;
		        if (rev != parseInt(cpf.charAt(9))){
							alert("CPF inválido");
							element.focus();
							return false;
						}
		    // Valida 2o digito
		    add = 0;
		    for (i = 0; i < 10; i ++)
		        add += parseInt(cpf.charAt(i)) * (11 - i);
		    rev = 11 - (add % 11);
		    if (rev == 10 || rev == 11)
		        rev = 0;
		    if (rev != parseInt(cpf.charAt(10))){
					alert("CPF inválido");
					element.focus();
					return false;
				}
		    return true;
		    
			});

	$(".select2").select2();

	if($(".checkradios input").length > 0){
		$(".checkradios input").checkradios();
	}

	$("#consultaCep").popover();

	// Add custom JS here
	$('a[rel=popover]').popover({
  		html: true,
  		trigger: 'hover',
  		placement: 'bottom',
  		content: function(){return '<img src="'+$(this).data('img') + '" />';}
	});


	// Carousel Phone
	$('#six-reasons .carousel').carousel({
	  interval: 3000
	})


})(jQuery);
