<?php

namespace AppBundle\Service;

use Doctrine\ORM\EntityManager;
use Symfony\Component\DependencyInjection\ContainerInterface;
use AppBundle\Entity\IntegracaoParticipacaoPontuada;

class ApiUnimedService
{
    protected $em;
    protected $logger;
    protected $container;

    public function __construct(EntityManager $em, ContainerInterface $container, $logger)
    {
        $this->em = $em;
        $this->logger = $logger;
        $this->container = $container;
    }

    public function log($message = '')
    {
        if (is_array($message)) {
            $message = print_r($message, true);
        }
        $this->logger->log('error', '[UNIMED - ApiUnimedService] ' . $message);
    }

    public function requestApiGerarPontuacao($body)
    {
        // $curl = curl_init("https://servicoshml.unimedbh.com.br/sco/api/basic/cooperado/v1/gerarPontuacao");
        $curl = curl_init("https://servicos.unimedbh.com.br/sco/api/basic/cooperado/v1/gerarPontuacao");

        $headers = array(
            "cache-control: no-cache",
            "content-type: application/json",
            'Access-Control-Allow-Origin: *',
            "Authorization: Basic b3BlbmFtLmFwcC5zYW1iYXRlY2g6KklLJlVKMXFh"
        );

        // $body = array(
        //     "crmCooperado"=> 25696,
        //     "codigoOrigem"=>"LMS",
        //     "codigoChaveRegra"=> "864612",
        //     "dataReferencia"=> "2018-09-09",
        //     "indicadorControleTransacao"=> "S"
        // );

        $payload = json_encode($body);

        // curl_setopt($curl, CURLOPT_VERBOSE, true);
        //curl_setopt($curl, CURLOPT_PROXYUSERPWD, "unimedbh\uni15851:+29j6kpm9");
        //curl_setopt($curl, CURLOPT_PROXY, '172.26.6.151');
        //curl_setopt($curl, CURLOPT_PROXYPORT, '8080');
        //curl_setopt($curl, CURLOPT_PROXYAUTH, CURLAUTH_NTLM);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl, CURLOPT_FAILONERROR, true); 
        //COOKIE NAO É MAIS NECESSARIO
        curl_setopt($curl, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($curl);
        $err = curl_error($curl);
        $this->log($err);
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        $this->log($httpCode);
        // Verifica se houve erros e exibe a mensagem de erro
        if($errno = curl_errno($curl)) {
            $error_message = curl_strerror($errno);
            $this->log("cURL error ({$errno}):\n {$error_message}");
        }
        curl_close($curl);

        return $response;
    }

    public function requestApiExtranetGetToken()
    {
        $url = 'https://extranethml.unimedbh.com.br/openam/json/authenticate';
        $ch = curl_init();

        $header[] = "X-OpenAM-Username: openam.app.sambatech;X-OpenAM-Password: *IK&UJ1qa;";
        $header[] = "Content-Type: application/json;";

        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');

        $body = array("stage" => "ldapService");

        if ($body) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($body));
        }

        $result = curl_exec($ch);

        return $result;
    }

    public function createEntity($client, $course, $userEvaluation, $status = 'P')
    {
        $participacaoPontuada = new IntegracaoParticipacaoPontuada();
        $participacaoPontuada->setCrmCooperado($client->getMatColaborador());
        $participacaoPontuada->setCodigoChaveRegra($course->getSalutarisId());
        $participacaoPontuada->setCodigoOrigem("LMS");
        $participacaoPontuada->setDataReferencia($userEvaluation->getDtCreation());
        $participacaoPontuada->setIndicadorControleTransacao("S");
        $participacaoPontuada->setStatus($status);
        $participacaoPontuada->setCourse($course);
        $participacaoPontuada->setClient($client);

        $this->em->persist($participacaoPontuada);
        $this->em->flush();

        return $participacaoPontuada;
    }

    public function createClonePendente($integracaoParticipacaoPontuada)
    {
        $participacaoPontuada = new IntegracaoParticipacaoPontuada();
        $participacaoPontuada->setCrmCooperado($integracaoParticipacaoPontuada->getCrmCooperado());
        $participacaoPontuada->setCodigoChaveRegra($integracaoParticipacaoPontuada->getCodigoChaveRegra());
        $participacaoPontuada->setCodigoOrigem($integracaoParticipacaoPontuada->getCodigoOrigem());
        $participacaoPontuada->setDataReferencia($integracaoParticipacaoPontuada->getDataReferencia());
        $participacaoPontuada->setIndicadorControleTransacao($integracaoParticipacaoPontuada->getIndicadorControleTransacao());
        $participacaoPontuada->setStatus("P");
        $participacaoPontuada->setCourse($integracaoParticipacaoPontuada->getCourse());
        $participacaoPontuada->setClient($integracaoParticipacaoPontuada->getClient());
        $participacaoPontuada->setParameterSent($integracaoParticipacaoPontuada->getParameterSent());

        $this->em->persist($participacaoPontuada);
        $this->em->flush();

        return $participacaoPontuada;
    }
}
