<?php

namespace AppBundle\Service;

use Doctrine\ORM\EntityManager;
use AppBundle\Entity\Course;
use Symfony\Component\Security\Core\Authorization\AuthorizationCheckerInterface;

class CourseService
{
    protected $container;
    protected $em;
    protected $logger;
    protected $authorizationChecker;

    public function __construct(
        $container,
        EntityManager $em,
        $logger,
        AuthorizationCheckerInterface $authorizationChecker
    ) {
        $this->container = $container;
        $this->em = $em;
        $this->logger = $logger;
        $this->authorizationChecker = $authorizationChecker;
    }

    public function createIntegrationFromFinishCourse($courseId, $user)
    {
        $repository = $this->em->getRepository('AppBundle:Course');
        $repositoryUserGroup = $this->em->getRepository('AppBundle:UserGroup');
        $integrationReturnRepository = $this->em->getRepository('AppBundle:IntegrationReturn');
        $integracaoParticipacaoPontuadaRepository = $this->em->getRepository('AppBundle:IntegracaoParticipacaoPontuada');
        $clientRepository = $this->em->getRepository('AppBundle:Client');
        $userEvaluationRepository = $this->em->getRepository('AppBundle:UserEvaluation');
        $course = $repository->find($courseId);

        if (!$user) {
            throw new \Exception('Usuario não encontrado');
        }

        if (!$course) {
            throw new \Exception('Curso não encontrado');
        }

        $category = $course->getCategory();

        $mainService = $this->container->get('main.service');
        $apiUnimedService = $this->container->get('apiunimed.service');

        $secretariaUserGroup = $repositoryUserGroup->findSecretaria();
        $userGroup = $user->getUsergroup();

        if($userGroup){
            $itemGroup = $this->transformGroupUser($userGroup->getItemGroup());
            if (!$this->authorizationChecker->isGranted('ROLE_SUPER_ADMIN')
                    && (in_array("CLAUSU.PERFIL_SECRETARIA_MEDICO", $itemGroup)
                    && in_array("OUTSYS_PORTALATENDENTE.PERFIL_COMUM", $itemGroup))
                && ($category && $category->isSecretaria())) {
                    $integrationReturn = $integrationReturnRepository->findOneBy(
                        array(
                            'course' => $course,
                            'user' => $user
                        )
                    );
                    if(!$integrationReturn){
                        $integrationReturn = $mainService->createIntegrationReturnEntity($user, $course);
                
                        // get token
                        $responseToken = $mainService->requestApiExtranetGetToken();
                        $responseToken = json_decode($responseToken, true);
                
                        if (!isset($responseToken['tokenId'])) {
                            throw \Exception('Error ao pegar o token API Informar Treinamento Concluido.');
                        }
                
                        $token = $responseToken['tokenId'];

                        // $this->log('Request - Token retornado pela api');
                        // $this->log($token);
                
                        // chamada api
                        $body['LoginUsuario'] = $user->getCpf();
                        // $body['LoginUsuario'] = $user->getLogin();
                        $body['CodigoTreinamento'] = $course->getId();
                        $body['NomeTreinamento'] = $course->getTitle();

                        $userEvaluations = $user->getUserEvaluations()->filter(function ($entry) use ($course) {
                            return $entry->getCourse()->getId() == $course->getId();
                        });
                        
                        $userEvaluation = count($userEvaluations) > 0 ? $userEvaluations->last() : null;
                        $dataCourseEnd = $userEvaluation ? $userEvaluation->getDtCreation()->format('Y-m-d\TH:i:s.u\Z') : null;
                        $body['DataConclusao'] = $dataCourseEnd;

                        $this->log('Body - Parametros enviados para api treinamentoConcluido');
                        $this->log(json_encode($body));

                        try {
                            $resTreinamentoConcluido = $mainService->requestApiTreinamentoConcluido($token, json_encode($body));
                            $resTreinamentoConcluido = json_decode($resTreinamentoConcluido, true);

                            $this->log('Request - Parametros recebidos pela API treinamentoConcluido');
                            $this->log(json_encode($resTreinamentoConcluido));

                            if (!$resTreinamentoConcluido) {
                                $integrationReturn->setMsgReturn("Error API Treinamento Concluido");
                                throw new \Exception('Error API Treinamento Concluido');
                            }

                            // atualizar o registro integrationReturn
                            if (isset($resTreinamentoConcluido['Mensagem'])) {
                                $integrationReturn->setMsgReturn($resTreinamentoConcluido['Mensagem']);
                            }

                            if (!empty($body)) {
                                $integrationReturn->setParameterSent(json_encode($body));
                            }

                            if (isset($resTreinamentoConcluido['OcorreuErro']) && $resTreinamentoConcluido['OcorreuErro'] != 0) {
                                $integrationReturn->setCodErro($resTreinamentoConcluido['OcorreuErro']);
                                $integrationReturn->setStatus('E');
                                $this->em->persist($integrationReturn);

                                $parameterSent = $integrationReturn->getParameterSent();
                                $dateConclusion = $integrationReturn->getDateConclusion();
                                $integrationReturnPendente = $mainService->createCloneIntegrationReturnPendente($user, $course, $dateConclusion, $parameterSent);
                                $this->em->persist($integrationReturnPendente);
                                $this->em->flush();
                                // Notificar por email da inscricao feita
                                $message = $integrationReturn->getMsgReturn();
                                $this->notificationUserEmail("alexandre.marques@unimedbh.com.br", "[LMS] Erro API Treinamento Concluido", $message);
                                $this->notificationUserEmail("ramon.msilva@unimedbh.com.br", "[LMS] Erro API Treinamento Concluido", $message);
                            } elseif (!isset($resTreinamentoConcluido['OcorreuErro']) || $resTreinamentoConcluido['OcorreuErro'] == 0) {
                                $integrationReturn->setStatus('I');
                            }

                            $this->em->persist($integrationReturn);
                        } catch (\Exception $e) {
                            $this->log($e);
                            $integrationReturn->setStatus('E');
                            $integrationReturn->setParameterSent(json_encode($body));

                            $parameterSent = $integrationReturn->getParameterSent();
                            $dateConclusion = $integrationReturn->getDateConclusion();
                            $integrationReturnPendente = $mainService->createCloneIntegrationReturnPendente($user, $course, $dateConclusion, $parameterSent);
                            $this->em->persist($integrationReturn);
                            $this->em->persist($integrationReturnPendente);
                        }
                        $this->em->flush();
                    }
                }else{
                // if(($course->getPontuation() && $course->getSalutarisId()) && $user->getUsergroup() && $user->getUsergroup()->getCooperated()){

                //     $participacaoPontuada = $integracaoParticipacaoPontuadaRepository->findOneBy(
                //         array(
                //             'course' => $course,
                //             'client' => $user
                //         )
                //     );
                //     $userEvaluation = $userEvaluationRepository->findOneBy(
                //         array(
                //             'course' => $course,
                //             'user' => $user
                //         ),
                //         array('grade' => 'DESC')
                //     );

                //     $client = $clientRepository->findOneById($user->getId());
                    
                //     if(!$participacaoPontuada && ($userEvaluation != null) && ($client !=null) ){
                //         $participacaoPontuada = $apiUnimedService->createEntity($client, $course, $userEvaluation);
                //         $body['crmCooperado'] = $participacaoPontuada->getCrmCooperado();
                //         $body['codigoChaveRegra'] = $participacaoPontuada->getCodigoChaveRegra();
                //         $body['codigoOrigem'] = $participacaoPontuada->getCodigoOrigem();
                //         $body['dataReferencia'] = $participacaoPontuada->getDataReferencia()->format('Y-m-d');
                //         $body['indicadorControleTransacao'] = $participacaoPontuada->getIndicadorControleTransacao();
                //         $this->log('Body - Parametros enviados para api participação pontuada');
                //         $this->log(json_encode($body));

                //         try {
                            
                //             $resParticipacaoPontuada = $apiUnimedService->requestApiGerarPontuacao($body);
                //             $resParticipacaoPontuada = json_decode($resParticipacaoPontuada, true);
                //             $this->log('Retorno');
                //             $this->log($resParticipacaoPontuada);
                //             if (!$resParticipacaoPontuada) {
                //                 $participacaoPontuada->setMsgRetorno("Error API Treinamento Concluido");
                //                 // $this->notificationUserEmail("joaozica@gmail.com", "[LMS] Erro API Participação Pontuada", "Error API Treinamento Concluido");
                //                 $this->notificationUserEmail("alexandre.marques@unimedbh.com.br", "[LMS] Erro API Participação Pontuada", "Error API Treinamento Concluido");
                //                 $this->notificationUserEmail("ramon.msilva@unimedbh.com.br", "[LMS] Erro API Participação Pontuada", "Error API Treinamento Concluido");
                //                 throw new \Exception('Error API Treinamento Concluido');
                //             }
                //             // atualizar o registro participacaoPontuada
                //             if (isset($resParticipacaoPontuada['descricaoErro'])) {
                //                 $participacaoPontuada->setMsgRetorno($resParticipacaoPontuada['descricaoErro']);
                //             }

                //             if (!empty($body)) {
                //                 $participacaoPontuada->setParameterSent(json_encode($body));
                //             }
                //             if (isset($resParticipacaoPontuada['codigoErro']) && $resParticipacaoPontuada['codigoErro'] != 0) {
                //                 $participacaoPontuada->setCodErro($resParticipacaoPontuada['codigoErro']);
                //                 $participacaoPontuada->setMsgRetorno($resParticipacaoPontuada['descricaoErro']);
                //                 $participacaoPontuada->setStatus('E');
                //                 $this->em->persist($participacaoPontuada);
                //                 $this->em->flush();

                //                 $participacaoPontuadaPendente = $apiUnimedService->createClonePendente($participacaoPontuada);
                //                 $this->em->persist($participacaoPontuadaPendente);
                //                 $this->em->flush();
                //                 // Notificar por email da inscricao feita
                //                 $message = $participacaoPontuada->getMsgRetorno();
                //                 // $this->notificationUserEmail("joaozica@gmail.com", "[LMS] Erro API Participação Pontuada", $message);
                //                 $this->notificationUserEmail("alexandre.marques@unimedbh.com.br", "[LMS] Erro API Participação Pontuada", $message);
                //                 $this->notificationUserEmail("ramon.msilva@unimedbh.com.br", "[LMS] Erro API Participação Pontuada", $message);
                //                 // $this->notificationUserEmail("joaozica@gmail.com", "[LMS] Erro API Participação Pontuada", $message);
                //             } elseif (!isset($resParticipacaoPontuada['codigoErro']) || $resParticipacaoPontuada['OcorreuErro'] == 0) {
                //                 $participacaoPontuada->setStatus('I');
                //             }
                //             $this->em->persist($participacaoPontuada);
                //         } catch (\Exception $e) {
                //             $this->log($e);
                //             $participacaoPontuada->setStatus('E');
                //             $participacaoPontuada->setMsgRetorno("Error API Treinamento Concluido");
                //             $this->notificationUserEmail("alexandre.marques@unimedbh.com.br", "[LMS] Erro API Participação Pontuada", $participacaoPontuada->getMsgRetorno());
                //             $this->notificationUserEmail("ramon.msilva@unimedbh.com.br", "[LMS] Erro API Participação Pontuada", $participacaoPontuada->getMsgRetorno());
                //             // $this->notificationUserEmail("joaozica@gmail.com", "[LMS] Erro API Participação Pontuada", $participacaoPontuada->getMsgRetorno());
                //             $participacaoPontuadaPendente = $apiUnimedService->createClonePendente($participacaoPontuada);
                //             $participacaoPontuada->setParameterSent(json_encode($body));
                //             $this->em->persist($participacaoPontuada);
                //             $this->em->persist($participacaoPontuadaPendente);
                //         }

                //         $this->em->flush();
                        
                //     }
                // }
            }
        }
    }

    public function transformGroupUser($group)
    {
        $func = function ($item) {
            return strtoupper(trim($item));
        };

        $groupDataList = explode(",", $group);
        $result = array_map($func, $groupDataList);

        return $result;
    }

    public function log($message = '')
    {
        if (is_array($message)) {
            $message = print_r($message, true);
        }
        $this->logger->log('error', '[unimed - CourseService] ' . $message);
    }

    /**
     * Enviar email de cancelamento
     * @param String $email
     * @param String $subject
     * @param String $message
     */
    public function notificationUserEmail($email, $subject, $message)
    {
        $mailMessage = \Swift_Message::newInstance()
              ->setSubject($subject)
              ->setFrom("no-reply@lmssambatech.com.br")
              ->setTo($email)
              ->setContentType("text/html")
              ->setBody($message);

        $this->container->get('mailer')->send($mailMessage);
    }
}
