<?php

namespace AppBundle\Service;

use Doctrine\ORM\EntityManager;
use AppBundle\Entity\Inscription;
use AppBundle\Entity\InscriptionStatus;

class InscriptionService
{
    protected $container;
    protected $em;
    protected $logger;

    public function __construct($container, EntityManager $em, $logger)
    {
        $this->container = $container;
        $this->em = $em;
        $this->logger = $logger;
    }

    public function incriptionInMassUsers($clients, $course)
    {
        // $clientsIdInscriptionByCourse = $this->getAllUsersFromInscriptionFilterCourse($course);
        $userRegistered = false;

        foreach ($clients as $client) {
            // if (!in_array($client->getId(), $clientsIdInscriptionByCourse)) {
                $userInscription = $this->em->getRepository('AppBundle:Inscription')->getLastInscriptionByUser($client, $course);
                if(!$userInscription || $userInscription->getInscriptionStatus()->getId() == InscriptionStatus::CANCELADO){
                    $inscription = $this->createInscriptionByInscriptionStatusApproved($client, $course);
                    $this->em->persist($inscription);
                    $userRegistered = true;
                }
            // }
        }

        if ($userRegistered) {
            $this->em->flush();
        }
    }

    public function getAllUsersFromInscriptionFilterCourse($course)
    {
        $repository = $this->em->getRepository('AppBundle:Inscription');
        $inscriptionStatusRepository = $this->em->getRepository('AppBundle:InscriptionStatus');
        $inscriptions = $repository->findBy(
            array(
                'course' => $course,
                'inscription_status' => $this->em->getReference('AppBundle:InscriptionStatus', InscriptionStatus::APROVADO)
            )
        );
        $clients = array();

        foreach ($inscriptions as $inscription) {
            if ($inscription->getUser()) {
                array_push($clients, $inscription->getUser()->getId());
            }
        }

        return $clients;
    }

    public function createInscriptionByInscriptionStatusApproved($user, $course, $attempts = null)
    {
        try {
            $inscription = new Inscription();
            $inscription->setUser($user);
            $inscription->setCourse($course);
            if ($course->getDisponibleDays()) {
                ///Instancia um novo objeto de matrícula
                $dtEnd = new \DateTime();
                if ($course->getDisponibleDays() > 730) {
                    $dtEnd->add(new \DateInterval('P730D'));
                } else {
                    $dtEnd->add(new \DateInterval('P'. $course->getDisponibleDays() .'D'));
                }
                $dtBegin = new \DateTime();
                $inscription->setDtBegin($dtBegin);
                $inscription->setDtEnd($dtEnd);
            }
            $inscription->setInscriptionStatus($this->em->getReference('AppBundle:InscriptionStatus', InscriptionStatus::APROVADO));

            if ($attempts) {
                $inscription->setAttempts($attempts);
            }

            return $inscription;
        } catch (Exception $e) {
            $this->log($e);
            throw new Exception($e);
        }
    }

    public function log($message = '')
    {
        if (is_array($message)) {
            $message = print_r($message, true);
        }
        $this->logger->log('error', '[unimed] ' . $message);
    }
}
