<?php

namespace AppBundle\Service;

use Doctrine\ORM\EntityManager;
use AppBundle\Entity\IntegrationReturn;

class MainService
{
    protected $container;
    protected $em;
    protected $logger;

    public function __construct($container, EntityManager $em, $logger)
    {
        $this->container = $container;
        $this->em = $em;
        $this->logger = $logger;
    }

    public function log($message = '')
    {
        if (is_array($message)) {
            $message = print_r($message, true);
        }
        $this->logger->log('error', '[unimed] ' . $message);
    }

    public function requestApiExtranetGetToken()
    {
        try {
            $curl = curl_init();

            $body = json_encode(array('stage' => 'ldapService'));

            curl_setopt_array($curl, array(
                // CURLOPT_URL => "https://extranetdsv.unimedbh.com.br/openam/json/authenticate",
                // CURLOPT_URL => "https://extranethml.unimedbh.com.br/openam/json/authenticate",
                CURLOPT_URL => "https://extranet.unimedbh.com.br/openam/json/authenticate",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => $body,
                CURLOPT_HTTPHEADER => array(
                    "Content-Type: application/json",
                    "X-OpenAM-Password: *IK&UJ1qa",
                    "X-OpenAM-Username: openam.app.sambatech"
                ),
            ));

            $response = curl_exec($curl);
            $err = curl_error($curl);

            curl_close($curl);

            if ($err) {
                $this->log("Request API Token Error #:".$err);
                return false;
            }

            return $response;
        } catch (Exception $e) {
            $this->log($e);
            return false;
        }
    }

    public function requestApiTreinamentoConcluido($token, $body)
    {
        try {
            $curl = curl_init();
            // $url = 'https://appdev.unimedbh.com.br/PortalAtendente/rest/IntegracaoSaberSempre/InformarTreinamentoConcluido';
            // $url = 'https://apphml.unimedbh.com.br/PortalAtendenteCore/rest/IntegracaoSaberSempre/InformarTreinamentoConcluido';
            // $url = 'https://app.unimedbh.com.br/PortalAtendenteCore/rest/IntegracaoSaberSempre/InformarTreinamentoConcluido';
            $url = 'https://app.unimedbh.com.br/PortalAtendente/rest/IntegracaoSaberSempre/InformarTreinamentoConcluido';

            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => $body,
                CURLOPT_HTTPHEADER => array(
                    "Content-Type: application/json",
                    "cache-control: no-cache",
                    "iPlanetDirectoryPro: ".$token
                  ),
            ));

            $response = curl_exec($curl);
            $err = curl_error($curl);

            curl_close($curl);

            if ($err) {
                $this->log("Request API IntegracaoSaberSempre InformarTreinamentoConcluido Error #:".$err);
                return false;
            }

            return $response;
        } catch (Exception $e) {
            $this->log($e);
            return false;
        }
    }

    public function createCloneIntegrationReturnPendente($user, $course, $dateConclusion, $parameterSent)
    {
        $integration = new IntegrationReturn();
        $integration->setStatus('P');
        $integration->setCourse($course);
        $integration->setUser($user);
        $integration->setDateConclusion($dateConclusion);
        $integration->setParameterSent($parameterSent);

        $this->em->persist($integration);
        $this->em->flush();

        return $integration;
    }

    public function createIntegrationReturnEntity($user, $course, $status = 'P')
    {
        $dateToday = new \Datetime();
        $integration = new IntegrationReturn();
        $integration->setStatus($status);
        $integration->setCourse($course);
        $integration->setUser($user);
        $integration->setDateConclusion($dateToday);

        $this->em->persist($integration);
        $this->em->flush();

        return $integration;
    }
}
