<?php

namespace AppBundle\Twig\Extension;

use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\Security\Core\Authorization\AuthorizationCheckerInterface;

class PermissionExtension extends \Twig_Extension
{
    protected $authorizationChecker;
    protected $session;
    protected $logger;

    public function __construct(AuthorizationCheckerInterface $authorizationChecker, Session $session, $logger)
    {
        $this->authorizationChecker = $authorizationChecker;
        $this->session   = $session;
        $this->logger = $logger;
    }

    public function getFunctions()
    {
        return array(
            new \Twig_SimpleFunction('verifyPermission', array($this, 'verifyPermission')),
        );
    }

    public function verifyPermission($action)
    {
        //Obtem as permissões salvas em sessão
        $user_access_permissions = $this->session->get('user_access_permissions');

        if (!in_array($action, array_column($user_access_permissions, 'guard'))
            && !in_array("all_permissions", array_column($user_access_permissions, 'guard'))) {
            return false;
        }

        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'permission';
    }
}
