<?php

namespace AuditBundle\Controller;

use JMS\Serializer\SerializerBuilder;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\BadRequestHttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class BaseController extends Controller
{

    /**
     * Retorna o service "logger".
     * @return \Monolog\Logger
     */
    protected function getLogger()
    {
        return $this->get("logger");
    }

    /**
     * Método para verificar acesso.
     * @return createNotFoundException
     */
    public function verifyAdmin()
    {
        if (!$this->get('security.authorization_checker')->isGranted('ROLE_SUPER_ADMIN')) {
            throw $this->createNotFoundException('Você não tem permissão para acessar esta tela.');
        }
    }

    /**
     * Atalho para geração de logs no sistema.
     * @param string $message Mensagem a ser incluida no log.
     * @param string $level Level do log. Default: error.
     */
    protected function log($message, $level = "error")
    {
        if (is_array($message)) {
            $message = print_r($message, true);
        }
        $this->get('logger')->log($level, '[UNIMED - AUDIT] ' . $message);
        // $this->get('logger')->log($level, $message);
    }

}
