<?php

namespace Certificado\CertificadoBundle\Controller;

use Knp\Snappy\Pdf as Snappy;
use Knp\Bundle\SnappyBundle\Snappy\Response\PdfResponse;
use AppBundle\Controller\BaseController;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Mpdf\Mpdf;
use Dompdf\Dompdf;

class CertificadoController extends BaseController
{

    /**
     * @Route("/gerar-imagem-certificado/{courseId}", name="gerar_imagem_certificado")
     **/
    public function gerarImagemCertificadoAction(Request $request, $courseId)
    {
        $service = $this->get("certificado.certificado_service");
        $course = $this->getDoctrine()->getRepository('AppBundle:Course')->find($courseId);

        if (!$course) {
            throw new \Exception('Curso não encontrado!');
        }
        $path = realpath($this->get('kernel')->getRootDir().'/../');

        $service->getInformacoesCourse($course, $path, parent::getUser());
    }

    /**
     * @Route("gerar-certificado-id/{id}", name="gerar_certificado_id")
     * @Template("CertificadoBundle:Certificado:imagem.html.twig")
     **/
    public function gerarImagemIdAction(Request $request, $id)
    {
        return array('id' => $id);
    }

    /**
     * @Route("teste-gerar-certificado-pdf/{id}", name="gerar_certificado_pdf_teste")
     **/
    public function testeCertificadoPdfAction(Request $request, $id)
    {
        $service = $this->get("certificado.certificado_service");
        $course = $this->getDoctrine()->getRepository('AppBundle:Course')->find($id);

        if (!$course) {
            throw new \Exception('Curso não encontrado!');
        }

        $path = realpath($this->get('kernel')->getRootDir().'/../');

        $filename = $service->saveTextAsImage($course, $this->getUser(), $path);

        $response = new Response();

        // Set headers
        $response->headers->set('Cache-Control', 'private');
        $response->headers->set('Content-type', mime_content_type($filename));
        $response->headers->set('Content-Disposition', 'attachment; filename="' . basename($filename) . '";');
        $response->headers->set('Content-length', filesize($filename));

        // Send headers before outputting anything
        $response->sendHeaders();

        $response->setContent(readfile($filename));

        return $response;
    }

    /**
     * @Route("gerar-certificado-pdf/{id}", name="gerar_certificado_pdf")
     **/
    public function gerarCertificadoPdfAction(Request $request, $id)
    {
        if ($this->getUser()==null) {
            return $this->redirect($this->generateUrl('homepage'));
        }
        $service = $this->get("certificado.certificado_service");
        $course = $this->getDoctrine()->getRepository('AppBundle:Course')->find($id);
        $configuration = $this->getDoctrine()->getRepository('AppBundle:Configuration')->find(1);

        if (!$course) {
            throw new \Exception('Curso não encontrado!');
        }
        $totalQuestions = $this->getDoctrine()->getRepository('AppBundle:Question')->questionsForCourseUser(parent::getUser(), $course);
        // $totalCorrectQuestions = $this->getDoctrine()->getRepository('AppBundle:Course')->questionsCorrectForCourseUser(parent::getUser(), $course);
        $totalEvaluations = 0;
        $totalEvaluationsGrade = 0;
        $dtLastEvaluation = null;
        if ($totalQuestions>0) {
            //Tratamento para buscar a melhor nota nas avaliações de todos os cursos
            foreach ($course->getModules() as $module) {
                if (count($module->getEvaluations())>0) {
                    $totalEvaluations++;
                    $nota = $this->getDoctrine()->getRepository('AppBundle:UserEvaluation')->getMelhoresNotas($this->getUser(), null, $module->getEvaluations()->get(0));
                    foreach ($nota as $value) {
                        $totalEvaluationsGrade+=$value["betterGrade"];
                        $dtLastEvaluation = $value["lastEvaluation"];
                    }
                }
            }
            $percentual = $totalEvaluationsGrade/$totalEvaluations;
            $percentual = number_format($percentual);
        } else {
            $percentual = 100;
        }


        $path = realpath($this->get('kernel')->getRootDir().'/../');

        $inscription = $this->getDoctrine()->getRepository('AppBundle:Inscription')->getLastInscriptionByUser($this->getUser(), $course);
        $inscription = $this->getDoctrine()->getRepository('AppBundle:Inscription')->getLastInscriptionByUser($this->getUser(), $course);
        $inscriptionLessons = $this->getDoctrine()->getRepository('AppBundle:InscriptionLesson')->findAllByInscription($inscription, true);
        $lastInscriptionLesson = end($inscriptionLessons);

        $filename = $service->saveTextAsImage($course, $this->getUser(), $percentual, $path, $lastInscriptionLesson, $dtLastEvaluation, $configuration);

        if (is_array($filename)) {
            $front = $filename['front'];
            $back = $filename['back'];
        } else {
            $front = $filename;
        }

        // $front = explode('web', $front);
        // $front = $front[1];

        // $html = $this->generateHTMLSimplePDF($front, $back);

        $html = $this->renderView('AppBundle:Course:certificado.teste.html.twig', array(
            'front'  => $front,
            'back' => isset($back) ? $back : null
        ));


        if(isset($_GET['return_html'])) {
            $frontImg = str_replace('/home/lms/public_html/lmssambatech/web','',$front);
            $backImg = str_replace('/home/lms/public_html/lmssambatech/web','',$back);
            echo '<img style="width:100%;height:auto;" src="'.$frontImg.'">';
            echo '<img style="width:100%;height:auto;" src="'.$backImg.'">';
            die();
        }

        $this->generatePDFMPDF($html);
    }

    public function generatePDFMPDF($html)
    {
        $mpdf = new Mpdf([
            'mode' => 'utf-8',
            'format' => 'A4-L',
            'margin_top' => 0,
            'margin_left' => 0,
            'margin_right' => 0,
            'margin_bottom' => 0
        ]);
        $mpdf->WriteHTML($html);
        $mpdf->Output();
    }

    public function generateHTMLSimplePDF($front, $back)
    {
        $html = '<html><head><meta charset="UTF-8"></head>';
        // $html .= `
        //     <style type="text/css">
        //     </style>
        // `;
        $html .= '<body>';
        // $html .= '<div style="page-break-after: always; margin: 0;">';
        $html .= '<div>';
        // $html .= '<img src="'. $front .'" width="100%" height="100%"></div>';
        $html .= '<img src="'. $front .'" width="96%"></div>';

        if (isset($back)) {
            // $html .= '<div style="page-break-after: always; margin: 0;">';
            $html .= '<div>';
            $html .= '<img src="'. $back .'" width="100%" height="100%"></div>';
        }

        $html .= '</body></html>';

        return $html;
    }

    public function generatePDFImagick($filename)
    {
        $image = new \Imagick($filename);
        $image->setImageFormat('pdf');
        $nameTempPDF = $this->generateRandomString();
        $image->writeImage($path . '/web/uploads/course/certificate/'. $nameTempPDF . '.pdf');

        $response = new BinaryFileResponse($path . '/web/'. $nameTempPDF .'.pdf');

        return $response;
    }

    public function generatePDFDOM($html)
    {
        $dompdf = new Dompdf();
        $dompdf->loadHtml($html);

        // (Optional) Setup the paper size and orientation
        $dompdf->setPaper('A4', 'landscape');

        // // Render the HTML as PDF
        $dompdf->render();

        // // Output the generated PDF to Browser
        //$dompdf->stream('teste.pdf');

        $dompdf->stream("unimed", array("Attachment"=>0));
    }

    public function generateImageCertificate($filename)
    {
        $response = new Response();

        // Set headers
        $response->headers->set('Cache-Control', 'private');
        $response->headers->set('Content-type', mime_content_type($filename));
        $response->headers->set('Content-Disposition', 'attachment; filename="' . basename($filename) . '";');
        $response->headers->set('Content-length', filesize($filename));

        // Send headers before outputting anything
        $response->sendHeaders();

        $response->setContent(readfile($filename));

        return $response;
    }

    public function generateRandomString($length = 10)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
}
