<?php

namespace Certificado\CertificadoBundle\Services;

use AppBundle\Entity\Course;

/**
* Class service de Certificado
*/
class CertificadoService
{
    public function gerarImagemSimples($text, $path_imagem)
    {
        $imagem = imagecreatefromjpeg($path_imagem);
        $preto = imagecolorallocate($imagem, 0, 0, 0);

        imagestring($imagem, 5, 15, 100, $text, $preto);
        imagejpeg($imagem, null, 80);

        return $imagem;
    }

    public function gerarImagemTextoEstilizado($text)
    {
        $path = $this->get('kernel')->getRootDir();

        $imagem = imagecreatefromjpeg($path.'/../web/arquivos/19.jpg');
        $preto = imagecolorallocate($imagem, 0, 0, 0);
        $font = $path.'/../web/fonts/fontawesome-webfont.ttf';

        imagettftext($imagem, 50, 0, 10, 50, $preto, $font, $text);
        imagejpeg($imagem);

        return $imagem;
    }

    public function getInformacoesCourse($course, $path, $user)
    {
        $certificado_imagem = $this->getCourseCertificadoImagem($course, $path);
        $coordenadas = $this->getCoordenadasCertificado($course);
        return $this->gerarCertificado($course, $certificado_imagem, $user);
    }

    public function getInformacoesCourseFromPdf($course, $path, $user)
    {
        $certificado_imagem = $this->getCourseCertificadoImagem($course, $path);
        // $coordenadas = $this->getCoordenadasCertificado($course);
        // return $this->gerarCertificadoFromPdf($course, $certificado_imagem,  $user);
        return $this->gerarCertificadoFromPdf($course, $certificado_imagem, $user, $path);
    }

    public function gerarCertificado($course, $certificado_imagem, $user)
    {
        // $tipo_imagem = explode('.',$course->getCertificate());
        $handle = finfo_open(FILEINFO_MIME);
        $mime_type = finfo_file($handle, $certificado_imagem);
        $mime_type = mime_content_type($certificado_imagem);

        switch (strtolower($mime_type)) {
            case 'image/jpeg':
                return $this->gerarCertificadoJPG($certificado_imagem, $course, $user);
                break;
            case 'image/jpg':
                return $this->gerarCertificadoJPG($certificado_imagem, $course, $user);
                break;
            case 'image/png':
                return $this->gerarCertificadoPNG($certificado_imagem, $course, $user);
                break;
            default:
                throw new \Exception("Formato inválido!");
                break;
        }
    }

    public function gerarCertificadoJPG($certificado_imagem, $curso, $user)
    {
        $imagem = imagecreatefromjpeg($certificado_imagem);

        $preto = imagecolorallocate($imagem, 0, 0, 0);

        imagestring($imagem, 5, 1072, 1139, utf8_decode($this->getNomeAluno($user)), $preto);
        imagestring($imagem, 5, 1074, 1236, $curso->getName(), $preto);
        imagestring($imagem, 5, 294, 1345, $curso->getDuracaoCurso(), $preto);
        imagestring($imagem, 5, 1088, 2039, $this->getDataPorExtenso(), $preto);

        imagejpeg($imagem, null, 100);

        return $imagem;
    }

    public function gerarCertificadoPNG($certificado_imagem, $curso, $user)
    {
        $imagem = imagecreatefrompng($certificado_imagem);
        $preto = imagecolorallocate($imagem, 0, 0, 0);

        imagestring($imagem, 5, 1072, 1139, utf8_decode($this->getNomeAluno($user)), $preto);
        imagestring($imagem, 5, 1074, 1236, $curso->getName(), $preto);
        imagestring($imagem, 5, 294, 1345, $curso->getDuracaoCurso(), $preto);
        imagestring($imagem, 5, 1088, 2039, $this->getDataPorExtenso(), $preto);

        imagejpeg($imagem, null, 100);

        return $imagem;
    }

    public function getCourseCertificadoImagem($course, $path)
    {
        // if (empty($course->getCertificate()))
        // {
        //     throw new \Exception("Não exite imagem de certificado para este curso");
        // }
        return $path.'/web/uploads/course/certificate/'.$course->getCertificate();
        //return $path.'/web/arquivos/2.png';
    }

    // public function getCoordenadasCertificado($course)
    // {
    //     if(empty($course->getCoordenadaNome()) || empty($course->getCoordenadaCurso())) {
    //         throw new \Exception("Não foram cadastradas as coordenadas para impressão no certificado!");
    //     }
    //     $nome = array();
    //     $coordenada_nome =  explode(';',$course->getCoordenadaNome());
    //     $nome['x'] = $coordenada_nome[0];
    //     $nome['y'] = $coordenada_nome[1];
    //
    //     $curso = array();
    //     $coordenada_curso =  explode(';',$course->getCoordenadaCurso());
    //     $curso['x'] = $coordenada_curso[0];
    //     $curso['y'] = $coordenada_curso[1];
    //
    //     return array('nome' => $nome, 'curso' => $curso);
    // }

    public function getNomeAluno($user)
    {
        return $user->getFirstName() .' '. $user->getLastName();
    }

    public function gerarCertificadoFromPdf($course, $certificado_imagem, $user, $path)
    {
        $handle = finfo_open(FILEINFO_MIME);
        $mime_type = finfo_file($handle, $certificado_imagem);
        $mime_type = mime_content_type($certificado_imagem);

        switch (strtolower($mime_type)) {
            case 'image/jpeg':
                return $this->gerarCertificadoJPGfromPdf($certificado_imagem, $course, $user, $path);
                break;
            case 'image/jpg':
                return $this->gerarCertificadoJPGfromPdf($certificado_imagem, $course, $user, $path);
                break;
            case 'image/png':
                return $this->gerarCertificadoPNGfromPdf($certificado_imagem, $course, $user, $path);
                break;
            default:
                throw new \Exception("Formato inválido!");
                break;
        }
    }

    /**
     * Gera imagem de certificado, a partir de arquivo JPG/JPEG para PDF
     * */
    public function gerarCertificadoJPGfromPdf($certificado_imagem, $curso, $user, $path)
    {
        $font = $path.'/web/fonts/Arial.ttf';

        $imagem = imagecreatefromjpeg($certificado_imagem);

        $preto = imagecolorallocate($imagem, 0, 0, 0);

        // imagestring( $imagem, 5, 1072, 1139, utf8_decode($this->getNomeAluno($user)), $preto);
        imagettftext($imagem, 40, 0, 200, 400, $preto, $font, utf8_decode($this->getNomeAluno($user)));
        imagettftext($imagem, 40, 0, 400, 600, $preto, $font, $curso->getName());
        // imagettftext($imagem, 40, 0, 294, 1345, $preto, $font, $curso->getDuracaoCurso());
        // imagettftext($imagem, 40, 0, 1088, 2030, $preto, $font, $this->getDataPorExtenso());

        return $this->gerarUri($imagem);
    }
    /**
     * Gera imagem de certificado, a partir de arquivo PNG para PDF
     * */
    public function gerarCertificadoPNGfromPdf($certificado_imagem, $curso, $user, $path)
    {
        $font = $path.'/web/fonts/Arial.ttf';

        $imagem = imagecreatefrompng($certificado_imagem);

        $preto = imagecolorallocate($imagem, 0, 0, 0);

        // imagestring( $imagem, 5, 1072, 1139, utf8_decode($this->getNomeAluno($user)), $preto);
        imagettftext($imagem, 40, 0, 1072, 1139, $preto, $font, utf8_decode($this->getNomeAluno($user)));
        imagettftext($imagem, 40, 0, 1777, 1236, $preto, $font, $curso->getName());
        imagettftext($imagem, 40, 0, 294, 1345, $preto, $font, $curso->getDuracaoCurso());
        imagettftext($imagem, 40, 0, 1088, 2030, $preto, $font, $this->getDataPorExtenso());

        return $this->gerarUri($imagem);
    }

    /**
     * Gera caminho src para imagem impressa via PDF
     * */
    public function gerarUri($imagem)
    {
        imagefilter($imagem, IMG_FILTER_PIXELATE, 1, true);
        imagefilter($imagem, IMG_FILTER_MEAN_REMOVAL);

        ob_start();
        imagejpeg($imagem);
        $contents = ob_get_contents();
        ob_end_clean();

        $dataUri = "data:image/jpeg;base64," . base64_encode($contents);

        return $dataUri;
    }
    /**
     * Define a orientação da página de acordo com o tamanho da imagem do certificado
     * @param $imagem_path (caminho da imagem/certificado)
     * */
    public function imageOrientation($imagem_path)
    {
        $exif = exif_read_data($imagem_path);

        $width = $exif['COMPUTED']['Width'];
        $height = $exif['COMPUTED']['Height'];

        if ($width > $height) {
            return 'landscape';
        }

        return 'portrait';
    }

    public function getDataPorExtenso()
    {
        setlocale(LC_ALL, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');
        return strftime('%d de %B de %Y', strtotime('today'));
    }

    public function getDataConclusaoExtenso($lastLesson)
    {
        setlocale(LC_ALL, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');
        $dateTime = $lastLesson->getFinished()->format('Y-m-d H:i:s');
        return strftime('%d de %B de %Y', strtotime($dateTime));
    }

    public function getDataConclusaoExtensoDtFinished($dtFinished)
    {
        setlocale(LC_ALL, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');
        // $dateTime = $dtFinished->format('Y-m-d H:i:s');
        $dateTime = date("Y-m-d H:i:s", strtotime($dtFinished));
        return strftime('%d de %B de %Y', strtotime($dateTime));
    }

    /**
     * Method convert given text to PNG image and returs
     * file name
     * @param type $text Text
     * @return string File Name
     */
    public function saveTextAsImage($course, $user, $percentual, $path, $lastLesson, $dtLastEvaluation, $configuration)
    {
        $font = $path.'/web/fonts/Arial.ttf';
        $fontBold = $path.'/web/fonts/Arial_Bold.ttf';
        $fontBlack = $path.'/web/fonts/Arial_Black.ttf';
        $font_size = 15;
        $angle = 0;

        $certificado_imagem = $file_name = $path.'/web/uploads/configuration/'. $configuration->getCertificateFront();
        if (preg_match("/.png$/", $certificado_imagem)) {
            $imagem = imagecreatefrompng($certificado_imagem);
        } else {
            $imagem = imagecreatefromjpeg($certificado_imagem);
        }
        //print assinatura
        if ($configuration->getSignature()) {
            
            $assinatura_imagem = $file_name = $path.'/web/uploads/configuration/'. $configuration->getSignature();
            if (preg_match("/.png$/", $assinatura_imagem)) {
                $signature = imagecreatefrompng($assinatura_imagem);
            } else {
                $signature = imagecreatefromjpeg($assinatura_imagem);
            }
            $black = imagecolorallocate($signature, 0, 0, 0);
            imagecolortransparent($signature, $black);
            imagecopy($imagem, $signature, 355, 455, 0, 0, 200, 120);
        }

        $preto = imagecolorallocate($imagem, 0, 0, 0);

        // Tamanho da imagem
        $image_width = imagesx($imagem);

        //Busca o x para o nome
        $name = strtoupper(utf8_decode($this->getNomeAluno($user)));
        $name_box = imagettfbbox($font_size, $angle, $fontBlack, $name);
        $name_width = $name_box[2]-$name_box[0]; // lower right corner - lower left
        
        $name_x = ((842 - $name_width)/2)+10;
        // $name_x = ($image_width/2) - ($name_width/2);

        //Busca o x para o curso
        $nome_curso = $course->getTitle();
        $break_line = false;
        if(strlen($nome_curso) > 60){
            $nome_curso = wordwrap($nome_curso, 60, "\n");
            $break_line = true;
        }
        $adjust_height = $break_line ? 20:0;
        $course_box = imagettfbbox($font_size, $angle, $fontBlack, $nome_curso);
        $course_width = $course_box[2] - $course_box[0]; // lower right corner - lower left corner

        $course_x = ((842 - $course_width)/2)+30;

        // $course_x = ($image_width/2) - ($course_width/2);

        //Busca o x para a data
        //   $data = $this->getDataPorExtenso();
        if ($dtLastEvaluation) {
            $data = $this->getDataConclusaoExtensoDtFinished($dtLastEvaluation);
        } else {
            $data = $this->getDataConclusaoExtenso($lastLesson);
        }
        
        $data_box = imagettfbbox($font_size, $angle, $font, $data);
        $data_width = $data_box[2]-$data_box[0]; // lower right corner - lower left corner
        $data_x = ($image_width/2) - ($data_width/2);

        //Busca o x para a duração
        $duracao = "Duração do curso: ".$course->getDuracaoCurso()."h";
        $duracao_box = imagettfbbox(12, $angle, $font, $duracao);
        $duracao_width = $duracao_box[2] - $duracao_box[0]; // lower right corner - lower left corner
        // $duracao_x = ($image_width/2) - ($duracao_width/2);
        $duracao_x = ((842 - $duracao_width)/2);

        // Write Text 'Certificado' no centro
        imagettftext($imagem, 25, 0, 320, 110, $preto, $font, 'CERTIFICADO');
        // Write Text ''
        imagettftext($imagem, 12, 0, 370, 145, $preto, $font, 'Certificamos que');
        //Nome do aluno
        imagettftext($imagem, $font_size, $angle, $name_x, 190, $preto, $fontBlack, $name);
        // Write Text ''
        imagettftext($imagem, 12, 0, 370, 220, $preto, $font, 'Concluiu o curso');
        //Nome do curso
        imagettftext($imagem, 14, $angle, $course_x, 250, $preto, $fontBlack, $nome_curso);
        // Write Text ''
        imagettftext($imagem, 12, 0, 230, 280+$adjust_height, $preto, $font, 'produzido pela Universidade Corporativa da Unimed-BH,');
        // Write Text ''
        imagettftext($imagem, 12, 0, 320, 300+$adjust_height, $preto, $font, 'obtendo '.$percentual.'% de aproveitamento.');
        //Duração do curso
        imagettftext($imagem, 12, $angle, $duracao_x , 340, $preto, $font, $duracao);

        // $dateCurrent = new \DateTime();
        // $day = $dateCurrent->format('d');
        // $month = $dateCurrent->format('d');
        // $year = $dateCurrent->format('Y');

        // setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        // date_default_timezone_set('America/Sao_Paulo');
        // $dateFull = strftime('%d de %B de %Y', strtotime('today'));

        // Write Text ''
        imagettftext($imagem, 12, 0, 310, 380, $preto, $font, 'Belo Horizonte, '.$data);

        // imagettftext($imagem, 8, 0, 370, 470, $preto, $font, '_____________________________________');
        // imagettftext($imagem, 8, 0, 430, 490, $preto, $font, 'Ana Alice Duarte Maciel');
        // imagettftext($imagem, 8, 0, 390, 505, $preto, $font, 'Gestora da Universidade Corporativa');
        // imagettftext($imagem, 8, 0, 450, 520, $preto, $font, 'da Unimed-BH');


        // //Aproveitamento
        // imagettftext($imagem, $font_size_small, $angle, 324, 330, $preto, $fontBold, $percentual."%");
        // //Data
        // imagettftext($imagem, $font_size_medium, $angle, $data_x, 385, $preto, $font, $data);
        // //Duração
        // imagettftext($imagem, 10, $angle, $duracao_x, 405, $preto, $font, $duracao);

        if ($configuration->getCertificateBack() && !empty($course->getDescription())) {
            $config = array(
                'font_size' => $font_size,
                'angle' => $angle,
                'preto' => $preto,
                'font' => $font,
            );

            $front = $this->generateCertificateImage($path, $imagem, $course->getId(), $user);
            $back = $this->generateBackCertificate($path, $certificado_imagem, $course, $user, $config, $configuration);

            return array(
                'front' => $front,
                'back' => $back,
            );

        // $certificado_back_imagem = $file_name = $path.'/web/uploads/course/certificate_back/'. $course->getCertificateBack();
            // $imagem_back = imagecreatefromjpeg($certificado_back_imagem);
            // list($width_x, $height_x) = getimagesize($certificado_imagem);
            // list($width_y, $height_y) = getimagesize($certificado_back_imagem);
            // // $outputImage = imagecreatetruecolor(600, 600);

            // //Conteúdo do verso
            // $description = strip_tags($course->getDescription());
            // $description = html_entity_decode($description);
            // imagettftext($imagem_back, $font_size, $angle, 25, 45, $preto, $font, $description);

            // $certificate_complete = imagecreatetruecolor($width_y, $height_x + $height_y);

            // imagecopy($certificate_complete, $imagem, 0, 0, 0, 0, $width_x, $height_x);
            // imagecopy($certificate_complete, $imagem_back, 0, $height_x, 0, 0, $width_y, $height_y);
            // $courseName = str_replace("/", "", $course->getTitle());
            // $file_name = $path . '/web/uploads/course/certificate/'."Certificado - " . $courseName . ".png";
            // imagepng($certificate_complete, $file_name);
            // imagedestroy($certificate_complete);

            // return $file_name;
        } else {
            $file_name = $this->generateCertificateImage($path, $imagem, $course->getId(), $user);

            return $file_name;
        }
    }

    public function generateCertificateImage($path, $imagem, $courseName, $user)
    {
        $outputImage = $imagem;
        $file_name = $path.'/web/uploads/course/temp/'."Certificado-". $courseName."-".$user->getId(). ".png";
        imagepng($outputImage, $file_name);
        imagedestroy($outputImage);

        return $file_name;
    }

    public function generateBackCertificate($path, $certificado_imagem, $course, $user, $config, $configuration)
    {
        $certificado_back_imagem = $path.'/web/uploads/configuration/'. $configuration->getCertificateBack();
        if (preg_match("/.png$/", $certificado_imagem)) {
            $imagem_back = imagecreatefrompng($certificado_back_imagem);
        }else{
            $imagem_back = imagecreatefromjpeg($certificado_back_imagem);
        }
        list($width_x, $height_x) = getimagesize($certificado_imagem);
        list($width_y, $height_y) = getimagesize($certificado_back_imagem);
        // $outputImage = imagecreatetruecolor(600, 600);

        //Conteúdo do verso
        $description = strip_tags($course->getDescription());
        $description = wordwrap($description, 120, "\n");
        $description = html_entity_decode($description);

        // $lines = explode('|', wordwrap($description, 115, '|'));

        imagettftext($imagem_back, 10, 0, 70, 100, $config['preto'], $config['font'], $description);

        $filename = $this->generateCertificateImage($path, $imagem_back, $course->getId().'(verso)', $user);

        return $filename;
    }
}
