<?php

namespace MediaCenterBundle\Repository;

use Doctrine\ORM\Query\Expr\Join;

/**
 * IqaCicleRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class IqaCicleRepository extends \Doctrine\ORM\EntityRepository
{

    public function findAvailableCicle()
    {
        $dateToday = new \DateTime();
        
        $conn = $this->getEntityManager()->getConnection();

        $sql = "
        select * from iqa_cicle iqa_c
        where iqa_c.begin_date <= :dateToday and iqa_c.end_date >= :dateToday
        limit 1
        ";
        $stmt = $conn->prepare($sql);
        $stmt->execute(array('dateToday' => $dateToday->format('Y-m-d H:i:s')));

        $results = $stmt->fetchAll();
        return ($results) ? $results[0] : null;
    }  

    public function findAvailableFromMediaCenter($ids = null, $contains = false)
    {
        $dateToday = new \DateTime();
        
        $conn = $this->getEntityManager()->getConnection();

        $containsString = "";
        if($ids){
            if($contains){
                $containsString = ' and sv.id in ('.implode(",", $ids).')';
            }else{
                $containsString = ' and sv.id not in ('.implode(",", $ids).')';
            }
        }

        $sql = "
        select sv.id as sv_id, sv.title as sv_title, sv.type as sv_type 
        from svmedia sv
        WHERE is_deleted = 0".$containsString."
        order by sv.title
        ";
        $stmt = $conn->prepare($sql);
        $stmt->execute();

        return $stmt->fetchAll();
    }

    public function getMediaFromMediaCenter($sv_id)
    {
        
        $conn = $this->getEntityManager()->getConnection();

        $sql = "
        select * from svmedia where id = :sv_id
        ";
        $stmt = $conn->prepare($sql);
        $stmt->execute(array('sv_id' => $sv_id));

        $results = $stmt->fetchAll();
        return ($results) ? $results[0] : null;

        
    }

    public function getUserHasSvMedia($crm, $svmedia_mid)
    {
        
        $conn = $this->getEntityManager()->getConnection();

        $sql = "
        select * from user_has_svmedia
where user_id in (select id from user where crm = :crm)
and is_scorepoint = 1
and svmedia_mid = :svmedia_mid
limit 1
        ";
        $stmt = $conn->prepare($sql);
        $stmt->execute(array('crm' => $crm, 'svmedia_mid' => $svmedia_mid));

        $results = $stmt->fetchAll();
        return ($results) ? $results[0] : null;

        
    }

}