<?php

namespace PagSeguroBundle\Entity;

/**
 * 2007-2014 [PagSeguro Internet Ltda.]
 *
 * NOTICE OF LICENSE
 *
 *Licensed under the Apache License, Version 2.0 (the "License");
 *you may not use this file except in compliance with the License.
 *You may obtain a copy of the License at
 *
 *http://www.apache.org/licenses/LICENSE-2.0
 *
 *Unless required by applicable law or agreed to in writing, software
 *distributed under the License is distributed on an "AS IS" BASIS,
 *WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *See the License for the specific language governing permissions and
 *limitations under the License.
 *
 *  @author    PagSeguro Internet Ltda.
 *  @copyright 2007-2014 PagSeguro Internet Ltda.
 *  @license   http://www.apache.org/licenses/LICENSE-2.0
 */

/***
 * Identifies a PagSeguro account
 */
class PagSeguroAccountCredentials extends PagSeguroCredentials
{

    /***
     * Primary email associated with this account
     */
    private $email;

    /***
     * PagSeguro token
     */
    private $token;

    /***
     * PagSeguro environment
     */
    private $environment;

    /***
     * Initializes a new instance of PagSeguroAccountCredentials class
     *
     * @throws Exception when credentials aren't provided.
     *
     * @param string $email
     * @param string $token
     * @param string $token
     */
    public function __construct($email, $token, $environment='production')
    {
        if ($email !== null && $token !== null) {
            $this->setEmail($email);
            $this->setToken($token);
            $this->setEnvironment($environment);
        } else {
            throw new Exception("Credentials not set.");
        }
    }

    /***
     * @return string the e-mail from this account credential object
     */
    public function getEmail()
    {
        return $this->email;
    }

    /***
     * Sets the e-mail from this account credential object
     */
    public function setEmail($email)
    {
        $this->email = $email;
    }

    /***
     * @return string the token from this account credential object
     */
    public function getToken()
    {
        return $this->token;
    }

    /***
     * Sets the token in this account credential object
     */
    public function setToken($token)
    {
        $this->token = $token;
    }

    /***
     * @return string the environment from this account credential object
     */
    public function getEnvironment()
    {
        return $this->environment;
    }

    /***
     * Sets the environment in this account credential object
     */
    public function setEnvironment($environment)
    {
        $this->environment = $environment;
    }

    /***
     * @return array a map of name value pairs that compose this set of credentials
     */
    public function getAttributesMap()
    {
        return array(
            'email' => $this->email,
            'token' => $this->token,
            'environment' => $this->environment
        );
    }

    /***
     * @return string a string that represents the current object
     */
    public function toString()
    {
        $credentials = array();
        $credentials['E-mail'] = $this->email;
        $credentials['Token'] = $this->token;
        $credentials['environment'] = $this->environment;
        return implode(' - ', $credentials);
    }
}
