<?php

namespace PagSeguroBundle\PagSeguroResources;

use PagSeguroBundle\Library\PagSeguroLibrary;

/**
 * 2007-2014 [PagSeguro Internet Ltda.]
 *
 * NOTICE OF LICENSE
 *
 *Licensed under the Apache License, Version 2.0 (the "License");
 *you may not use this file except in compliance with the License.
 *You may obtain a copy of the License at
 *
 *http://www.apache.org/licenses/LICENSE-2.0
 *
 *Unless required by applicable law or agreed to in writing, software
 *distributed under the License is distributed on an "AS IS" BASIS,
 *WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *See the License for the specific language governing permissions and
 *limitations under the License.
 *
 *  @author    PagSeguro Internet Ltda.
 *  @copyright 2007-2014 PagSeguro Internet Ltda.
 *  @license   http://www.apache.org/licenses/LICENSE-2.0
 */

class PagSeguroResources
{

    /**
     * @var
     */
    private static $resources;
    /**
     * @var
     */
    private static $data;
    /**
     *
     */
    const VAR_NAME = 'PagSeguroResources';

    /**
     * @throws Exception
     */
    private function __construct()
    {
        define('ALLOW_PAGSEGURO_RESOURCES', true);
        //require_once ".." . DIRECTORY_SEPARATOR . "Resources" . DIRECTORY_SEPARATOR .
            //"PagSeguroResourcesContent.php";

        $PagSeguroResources['baseUrl'] = array();
        $PagSeguroResources['baseUrl']['production'] = "https://pagseguro.uol.com.br";
        $PagSeguroResources['baseUrl']['sandbox'] = "https://sandbox.pagseguro.uol.com.br";

        // Static URLs
        $PagSeguroResources['staticUrl'] = array();
        $PagSeguroResources['staticUrl']['production'] = "https://stc.pagseguro.uol.com.br";
        $PagSeguroResources['staticUrl']['sandbox'] = "https://stc.sandbox.pagseguro.uol.com.br";

        // WebService URLs
        $PagSeguroResources['webserviceUrl'] = array();
        $PagSeguroResources['webserviceUrl']['production'] = "https://ws.pagseguro.uol.com.br";
        $PagSeguroResources['webserviceUrl']['sandbox'] = "https://ws.sandbox.pagseguro.uol.com.br";

        // Payment service
        $PagSeguroResources['paymentService'] = array();
        $PagSeguroResources['paymentService']['servicePath'] = "/v2/checkout";
        $PagSeguroResources['paymentService']['checkoutUrl'] = "/v2/checkout/payment.html";
        $PagSeguroResources['paymentService']['baseUrl']['production'] = "https://pagseguro.uol.com.br";
        $PagSeguroResources['paymentService']['baseUrl']['sandbox'] = "https://sandbox.pagseguro.uol.com.br";
        $PagSeguroResources['paymentService']['serviceTimeout'] = 20;

        // Session service
        $PagSeguroResources['sessionService'] = array();
        $PagSeguroResources['sessionService']['url'] = "/v2/sessions";

        //Installment service
        $PagSeguroResources['installmentService'] = array();
        $PagSeguroResources['installmentService']['url'] = "/checkout/v2/installments.json";

        // Direct payment service
        $PagSeguroResources['directPaymentService'] = array();
        $PagSeguroResources['directPaymentService']['servicePath'] = "/v2/transactions";
        $PagSeguroResources['directPaymentService']['checkoutUrl'] = "/v2/transactions";
        $PagSeguroResources['directPaymentService']['serviceTimeout'] = 20;

        // PreApproval service
        $PagSeguroResources['preApproval'] = array();
        $PagSeguroResources['preApproval']['servicePath'] = "/v2/pre-approvals/request";
        $PagSeguroResources['preApproval']['checkoutUrl'] = "/v2/checkout";
        $PagSeguroResources['preApproval']['cancelUrl'] = "/v2/pre-approvals/cancel/";
        $PagSeguroResources['preApproval']['findUrl'] = "/v2/pre-approvals/";
        $PagSeguroResources['preApproval']['paymentUrl'] = "/v2/pre-approvals/payment";
        $PagSeguroResources['preApproval']['requestUrl'] = "/v2/pre-approvals/request.html";
        $PagSeguroResources['preApproval']['baseUrl']['production'] = $PagSeguroResources['webserviceUrl']['production'];
        $PagSeguroResources['preApproval']['baseUrl']['sandbox'] = $PagSeguroResources['webserviceUrl']['sandbox'];
        $PagSeguroResources['preApproval']['serviceTimeout'] = 20;

        // Notification service
        $PagSeguroResources['notificationService'] = array();
        $PagSeguroResources['notificationService']['servicePath'] = "/v3/transactions/notifications";
        $PagSeguroResources['notificationService']['applicationPath'] = "v2/authorizations/notifications";
        $PagSeguroResources['notificationService']['preApprovalPath'] = "v2/pre-approvals/notifications";
        $PagSeguroResources['notificationService']['serviceTimeout'] = 20;

        // Transaction search service
        $PagSeguroResources['transactionSearchService'] = array();
        $PagSeguroResources['transactionSearchService']['servicePath']['v2'] = "/v2/transactions";
        $PagSeguroResources['transactionSearchService']['servicePath']['v3'] = "/v3/transactions";
        $PagSeguroResources['transactionSearchService']['serviceTimeout'] = 20;

        // Authorizations service
        $PagSeguroResources['authorizationService'] = array();
        $PagSeguroResources['authorizationService']['servicePath'] = "/v2/authorizations";
        $PagSeguroResources['authorizationService']['approvalUrl'] = "/v2/authorization/request.jhtml";
        $PagSeguroResources['authorizationService']['requestUrl'] = "/request";
        $PagSeguroResources['authorizationService']['serviceTimeout'] = 20;

        // Refund service
        $PagSeguroResources['refundService'] = array();
        $PagSeguroResources['refundService']['servicePath'] = "/v2/transactions/refunds";
        $PagSeguroResources['refundService']['serviceTimeout'] = 200;

        // Cancels service
        $PagSeguroResources['cancelService'] = array();
        $PagSeguroResources['cancelService']['servicePath'] = "/v2/transactions/cancels";
        $PagSeguroResources['cancelService']['serviceTimeout'] = 200;

        $varName = self::VAR_NAME;
        if (isset($$varName)) {
            self::$data = $$varName;
            unset($$varName);
        } else {
            throw new \Exception("Resources is undefined.");
        }
    }

    /**
     * @return PagSeguroResources
     */
    public static function init()
    {
        if (self::$resources == null) {
            self::$resources = new PagSeguroResources();
        }
        return self::$resources;
    }

    /**
     * @param $key1
     * @param null $key2
     * @return mixed
     * @throws Exception
     */
    public static function getData($key1, $key2 = null)
    {
        if ($key2 != null) {
            if (isset(self::$data[$key1][$key2])) {
                return self::$data[$key1][$key2];
            } else {
                throw new \Exception("Resources keys {$key1}, {$key2} not found.");
            }
        } else {
            if (isset(self::$data[$key1])) {
                return self::$data[$key1];
            } else {
                throw new \Exception("Resources key {$key1} not found.");
            }
        }
    }

    /**
     * @param $key1
     * @param $key2
     * @param $value
     * @throws Exception
     */
    public static function setData($key1, $key2, $value)
    {
        if (isset(self::$data[$key1][$key2])) {
            self::$data[$key1][$key2] = $value;
        } else {
            throw new \Exception("Resources keys {$key1}, {$key2} not found.");
        }
    }

    /**
     * @param $environment
     * @return mixed
     * @throws Exception
     */
    public static function getWebserviceUrl($environment)
    {
        if (isset(self::$data['webserviceUrl']) &&
            isset(self::$data['webserviceUrl'][$environment])
        ) {
            return self::$data['webserviceUrl'][$environment];
        } else {
            throw new \Exception("WebService URL not set for $environment environment. ".self::$data['paymentService']['baseUrl'][$environment]);
        }
    }

    /**
     * @param $environment
     * @return mixed
     * @throws Exception
     */
    public static function getPaymentUrl($environment)
    {
        if (isset(self::$data['paymentService']) && isset(self::$data['paymentService']['baseUrl']) &&
            isset(self::$data['paymentService']['baseUrl'][$environment])
        ) {
            return self::$data['paymentService']['baseUrl'][$environment];
        } else {
            throw new \Exception("Payment URL not set for $environment environment.");
        }
    }

    /**
     * @param $environment
     * @return mixed
     * @throws Exception
     */
    public static function getBaseUrl($environment)
    {
        if (isset(self::$data['baseUrl']) &&
            isset(self::$data['baseUrl'][$environment])
        ) {
            return self::$data['baseUrl'][$environment];
        } else {
            throw new \Exception("Base URL not set for $environment environment.");
        }
    }

    /**
     * @param $environment
     * @return mixed
     * @throws Exception
     */
    public static function getStaticUrl($environment)
    {
        if (isset(self::$data['staticUrl']) &&
            isset(self::$data['staticUrl'][$environment])
        ) {
            return self::$data['staticUrl'][$environment];
        } else {
            throw new \Exception("Static URL not set for $environment environment.");
        }
    }

    /**
     * @return mixed
     * @throws Exception
     */
    public static function getInstallmentUrl()
    {
        if (isset(self::$data['installmentService']) &&
            isset(self::$data['installmentService']['url'])
        ) {
            return self::$data['installmentService']['url'];
        } else {
            throw new \Exception("Installment base URL not found");
        }
    }

    /**
     * @return mixed
     * @throws Exception
     */
    public static function getAuthorizationUrl()
    {
        if (isset(self::$data['authorizationService']) &&
            isset(self::$data['authorizationService']['servicePath'])
        ) {
            return self::$data['authorizationService']['servicePath'];
        } else {
               throw new \Exception("Authorization service path URL not found");
        }
    }

    /**
     * @return mixed
     * @throws Exception
     */
    public static function getSessionUrl()
    {
        if (isset(self::$data['sessionService']) &&
            isset(self::$data['sessionService']['url'])
        ) {
            return self::$data['sessionService']['url'];
        } else {
            throw new \Exception("Session base URL not found");
        }
    }
}
