<?php

namespace Samba\VideosBundle\Entity;

/**
 * Classe para representar o retorno do Gateway de pagamento.
 */
class SambaClient {

    // Token de acesso a api
    private $access_token;

    // pid do cliente
    private $pid;

    // Player Key
    private $player_key;

    // Url de acesso da api
    private $urlApi;

    /**
     * Set access_token
     *
     * @param string $access_token;
     */
    public function setAccessToken($access_token) {
        $this->access_token = $access_token;
    }

    /**
     * Get access_token
     *
     * @return string
     */
    public function getAccessToken() {
        return $this->access_token;
    }

    /**
     * Set pid
     *
     * @param String $pid;
     */
    public function setPid($pid) {
        $this->pid = $pid;
    }

    /**
     * Get pid
     *
     * @return String
     */
    public function getPid() {
        return $this->pid;
    }

    /**
     * Set player_key
     *
     * @param String $player_key;
     */
    public function setPlayerKey($player_key) {
        $this->player_key = $player_key;
    }

    /**
     * Get player_key
     *
     * @return String
     */
    public function getPlayerKey() {
        return $this->player_key;
    }

    /**
     * Set urlApi
     *
     * @param string $urlApi
     */
    public function setUrlApi($urlApi) {
        $this->urlApi = $urlApi;
    }

    /**
     * Get urlApi
     *
     * @return string
     */
    public function getUrlApi() {
        return $this->urlApi;
    }

    /**
     * Construct the Google Client.
     *
     * @param $config Google_Config or string for the ini file to load
     */
    public function __construct($config = array())
    {
      $this->access_token = $config['access_token'];
      $this->pid = $config['pid'];
      $this->player_key = $config['player_key'];
      $this->urlApi = $config['urlApi'];
    }


}
