<?php

namespace Samba\VideosBundle\Services;

use Samba\VideosBundle\Entity\SambaClient;

/**
 * Class SambaVideosClient
 *
 * This is the samba client
 */
class SambaVideosClient
{
    /**
     * @var \SambaClient
     */
    protected $client;

    /**
     * @param array $config
     */
    public function __construct(array $config)
    {
        $client = new SambaClient($config);

        $this->client = $client;
    }

    /**
     * @return SambaClient
     */
    public function getSambaClient()
    {
        return $this->client;
    }

    public function getAccessToken()
    {
        return $this->client->getAccessToken();
    }

    public function getPid()
    {
        return $this->client->getPid();
    }

    public function getPlayerKey()
    {
        return $this->client->getPlayerKey();
    }

    public function getUrlApi()
    {
        return $this->client->getUrlApi();
    }
}
