<?php

namespace Samba\VideosBundle\Services;

/**
 * Class AnalyticsService
 *
 * This is the class that communicates with analytics api
 */
class VideosService
{
  /**
   * @var SambaClient client
   */
  public $client;

  /**
   * Constructor
   * @param SambaClient $client
   */
  public function __construct(SambaVideosClient $client)
  {
      $this->client = $client;
  }

  /**
   * @return String
   */
  public function getTeste()
  {
      return $this->client->getAccessToken()." _ ".$this->client->getPid()." _ ".$this->client->getPlayerKey();
  }

  function getPlayer($media) {
      return 'http://fast.player.liquidplatform.com/pApiv2/embed/'.$this->client->getPlayerKey().'/'.$media->id.'?volume=100&startOutput=360p&skipAd=true';
  }

  function getCategories() {
      $params = "categories?access_token=".$this->client->getAccessToken()."&pid=".$this->client->getPid();
      $output = $this->getBySambaVideos($params);
      $output = str_replace(array('<![CDATA[', ']]>'), '', $output);
      $result = json_decode($output);
      if ($result) {
          return reset($result);
      }
      return array();
  }

  function getCategoryByRef($category_ref, $categories = NULL) {
      if (empty($categories)) {
          $categories = getCategorias();
      }
      if (is_array($categories)) {
          foreach ($categories as $category) {
              $category_name = reset($category['dados']->name);
              $category_name_url = toUrl($category_name);
              $return = NULL;
              if ($category_name_url == $category_ref) {
                  $return = $category['dados'];
                  break;
              } elseif (!isset($GLOBALS['category-liquid-ref']) && isset($category['subcategorias'])) {
                  $returnSub = getCategoryByRef($category_ref, $category['subcategorias']);
                  if (!empty($returnSub)) {
                      $return = $returnSub;
                      break;
                  }
              }
          }

          return $return;
      }
  }

  private function getMediasParams($search) {
      $param = "medias?access_token=".$this->client->getAccessToken()."&pid=".$this->client->getPid()."&sort=DESC&status=ACTIVE&published=true";
      if (!empty($search)) {
          $param .= $search;
      }
      return $param;
  }

  public function getMedias($limit = 50, $offset = 0, $search = NULL, $orderBy = 'POSTDATE', $sort = 'DESC') {
      $param = $this->getMediasParams($search);
      $param .= "&limit={$limit}&start={$offset}&orderby={$orderBy}&sort={$sort}";
      $output = $this->getBySambaVideos($param);
      return json_decode($output);
  }

  public function getMedia($id) {
      $output = $this->getBySambaVideos("medias/{$id}/?access_token=".$this->client->getAccessToken()."&pid=".$this->client->getPid());
      return $output;
      $return = json_decode($output);
    if(array_key_exists("exception",$return)){
        return null;
    }else{
        return $return;
    }
}

  function removerAcentuacao($str) {
      return $return;
  }

  function toUrl($str) {
      $str = str_replace(array('?', '-', '–'), array('', '-_-', '-__-'), $str);
      $str = strtr(utf8_decode($str), utf8_decode('ŠŒŽšœžŸ¥µÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝßàáâãäåæçèéêëìíîïðñòóôõöøùúûüýÿ'), 'SOZsozYYuAAAAAAACEEEEIIIIDNOOOOOOUUUUYsaaaaaaaceeeeiiiionoooooouuuuyy-');
      $str = utf8_encode($str);
      $str = str_replace('-__-', '–', $str);
      $str = urlencode(strtolower(str_replace(" ", "-", trim($str))));
      return $str;
  }

  function urlToSearch($str) {
      $str = strtr(utf8_decode($str), utf8_decode('ŠŒŽšœžŸ¥µÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝßàáâãäåæçèéêëìíîïðñòóôõöøùúûüýÿ'), 'SOZsozYYuAAAAAAACEEEEIIIIDNOOOOOOUUUUYsaaaaaaaceeeeiiiionoooooouuuuyy-');
      $str = str_replace(array('-', ' _ '), array(' ', '-'), $str);
      $str = str_replace(array('%', ' ', '–', '+', '#'), array('%25', '%20', '%E2%80%93', '%2B', '%23'), $str);
      return $str;
  }

  function mediaToUrl($media) {
      $canal = (isset($media->categoryName) ? $this->toUrl($media->categoryName) : 'videos');
      $media_ref = $this->toUrl($media->title);
      return "/{$canal}/videos/{$media_ref}/";
  }

  function getThumbBySize($video, $size) {
      $thumbUrl = null;
      $thumbs = $video->thumbs;
      foreach ((array) $thumbs as $thumb) {
          if ($thumb->width == $size) {
              $thumbUrl = $thumb->url;
              break;
          }
      }
      return $thumbUrl;
  }

  function getTags($media) {
      $tags = array();
      foreach($media->tags as $key => $tag) {
          $tag = (string)$tag;
          $tags[$this->toUrl($tag)] = $tag;
      }
      return $tags;
  }

  public function getTotalItens($search = NULL) {
      return 50;
      $params = $this->getMediasParams($search);
      $url = $this->urlApi . $params;
      $headers = get_headers($url);
      $totalItens = 0;
      foreach ($headers as $header) {
          if (strpos($header, 'totalMedias:') !== false) {
              $array = explode(' ', $header);
              $totalItens = $array[1];
              break;
          }
      }
      return $totalItens;
  }

  private function getBySambaVideos($params) {
      $url = $this->client->getUrlApi() . $params;
      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $url);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
      curl_setopt($ch, CURLOPT_HEADER, FALSE);
      return curl_exec($ch);
  }
}
