<?php

namespace SoapBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Zend\Soap;

class InscriptionSoapController extends Controller
{
      public function init()
      {
          // No cache
          ini_set('soap.wsdl_cache_enable', 0);
          ini_set('soap.wsdl_cache_ttl', 0);
      }

      /**
       * @Route("/soap/inscriptions/", name="api_soap_inscriptions_index")
       */
      public function indexAction()
      {
          // if(isset($_GET['wsdl'])) {
          //     return $this->handleWSDL($this->generateUrl('api_soap_inscriptions_index', array(), true), 'inscriptions_service');
          // } else {
          //     return $this->handleSOAP($this->generateUrl('api_soap_inscriptions_index', array(), true), 'inscriptions_service');
          // }
          ini_set("soap.wsdl_cache_enabled", "0");

          $options = array(
            'uri' => $this->generateUrl('api_soap_inscriptions_index', array(), true),
            'cache_wsdl' => WSDL_CACHE_NONE,
            'exceptions' => true
          );

          $server = new \SoapServer(dirname(__FILE__).'/../../../web/soap/unimed_inscription.wsdl', $options);
          $server->setObject($this->get('inscriptions_service'));

          $response = new Response();
          $response->headers->set('Content-Type', 'text/xml; charset=utf-8');

          ob_start();
          $server->handle();
          $response->setContent(ob_get_clean());

          return $response;
      }

      /**
      * return the WSDL
      */
      public function handleWSDL($uri, $class)
      {
          // Soap auto discover
          $autodiscover = new Soap\AutoDiscover();
          $autodiscover->setClass($this->get($class));
          $autodiscover->setUri($uri);

         // Response
         $response = new Response();
         $response->headers->set('Content-Type', 'text/xml; charset=ISO-8859-1');
         ob_start();

         // Handle Soap
         $autodiscover->handle();
         $response->setContent(ob_get_clean());
         return $response;
      }

      /**
       * execute SOAP request
       */
      public function handleSOAP($uri, $class)
      {
          // Soap server
          $soap = new Soap\Server(null,
              array('location' => $uri,
              'uri' => $uri,
          ));
          $soap->setClass($this->get($class));

          // Response
          $response = new Response();
          $response->headers->set('Content-Type', 'text/xml; charset=ISO-8859-1');

          ob_start();
          // Handle Soap
          $soap->handle();
          $response->setContent(ob_get_clean());
          return $response;
      }
}
