<?php

namespace SoapBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Zend\Soap;

class SoapController extends Controller
{
    protected $host_soap = "dev.unimed.com.br";

    public function init()
    {
        // No cache
        ini_set('soap.wsdl_cache_enable', 0);
        ini_set('soap.wsdl_cache_ttl', 0);
    }

    /**
     * @Route("/soap/", name="api_soap_index")
     */
    public function indexAction()
    {
        if (isset($_GET['wsdl'])) {
            return $this->handleWSDL($this->generateUrl('api_soap_index', array(), true), 'soap_service');
        } else {
            return $this->handleSOAP($this->generateUrl('api_soap_index', array(), true), 'soap_service');
        }
        ini_set("soap.wsdl_cache_enabled", "0");

        $options = array(
          'uri' => $this->generateUrl('api_soap_index', array(), true),
          'cache_wsdl' => WSDL_CACHE_NONE,
          'exceptions' => true
        );

        $server = new \SoapServer(dirname(__FILE__).'/../../../web/soap/unimed.wsdl', $options);
        $server->setObject($this->get('soap_service'));

        $response = new Response();
        $response->headers->set('Content-Type', 'text/xml; charset=utf-8');

        ob_start();
        $server->handle();
        $response->setContent(ob_get_clean());

        return $response;
    }

    /**
     * @Route("/soap/testCadastroEvento", name="api_soap_cadastroEvento")
     */
    public function testCadastroEventoAction()
    {
        $opts = array(
            'http' => array(
                'user_agent' => 'PHPSoapClient'
            )
        );
        $context = stream_context_create($opts);
        $client  = new \SoapClient("http://" . $this->host_soap . "/app_dev.php/api/soap/?wsdl", array(
            'stream_context' => $context,
            'cache_wsdl' => WSDL_CACHE_MEMORY,
            'trace' => 1,
            'encoding' => ' UTF-8'
        ));

        $response = $client->CadastroEvento("Course Teste SOAP", 123, "123", "123", '24/04/2017', '25/04/2017', '10', 5, 2, "Teste", '30/04/2017', 20, "Teste", 1, "2");
        var_dump($response);
    }

    /**
     * @Route("/soap/testInformaProcessamento", name="api_soap_informaProcessamento")
     */
    public function testInformaProcessamentoAction()
    {
        $client   = new \SoapClient("http://" . $this->host_soap . "/app_dev.php/api/soap/?wsdl");
        $response = $client->InformaProcessamento();
        var_dump($response);
    }

    /**
     * @Route("/soap/testGetToken", name="api_soap_gettoken")
     */
    public function testGetTokenAction()
    {
        $client   = new \SoapClient("http://hml.lmssambatech.com.br/api/soap/?wsdl");
        $response = $client->GetToken('unimedbh', 'irWuTaMfhLWp3e4Y21TI');
        var_dump($response);
    }

    /**
     * @Route("/soap/testConsultaParticipante", name="api_soap_consultaParticipante")
     */
    public function testConsultaParticipanteAction()
    {
        $client   = new \SoapClient("http://hml.lmssambatech.com.br/app_dev.php/api/soap/?wsdl");
        $response = $client->GetToken(testConsultaParticipante);
        var_dump($response);
    }

    /**
     * @Route("/soap/testCadastroParticipanteAgrupado", name="api_soap_cadastroParticipanteAgrupado")
     */
    public function testCadastroParticipanteAgrupadoAction()
    {
        $client = $this->buildSoapClient();

        $participantes = array(
            array(
                'num_enterprise' => 2,
                'tip_colaborador' => 3,
                'mat_colaborador' => 15,
                'codPes' => 30,
                'sitCua' => 45,
                'datIni' => 50,
                'codRet' => 32,
                'menRet' => 17,
                'codOpe' => 1
            )
        );

        $response = $client->CadastroParticipanteAgrupado($participantes);
        //$response = $client->__soapCall('CadastroParticipanteAgrupado', array('participantes' => $participantes));
        var_dump($response);
    }

    public function buildSoapClient()
    {
        $opts = array(
            'http' => array(
                'user_agent' => 'PHPSoapClient'
            )
        );
        $context = stream_context_create($opts);
        $client  = new \SoapClient("http://" . $this->host_soap . "/app_dev.php/api/soap/?wsdl", array(
            'stream_context' => $context,
            'cache_wsdl' => WSDL_CACHE_MEMORY,
            'trace' => 1,
            'encoding' => ' UTF-8',
        ));

        return $client;
    }

    /**
     * return the WSDL
     */
    public function handleWSDL($uri, $class)
    {
        // Soap auto discover
        $autodiscover = new Soap\AutoDiscover(new \Zend\Soap\Wsdl\ComplexTypeStrategy\ArrayOfTypeSequence());
        $autodiscover->setClass($this->get($class));
        $autodiscover->setUri($uri);

        // Response
        $response = new Response();
        $response->headers->set('Content-Type', 'text/xml; charset=ISO-8859-1');
        ob_start();

        // Handle Soap
        $autodiscover->handle();
        $response->setContent(ob_get_clean());
        return $response;
    }

    /**
     * execute SOAP request
     */
    public function handleSOAP($uri, $class)
    {
        // Soap server
        $soap = new Soap\Server(null, array(
            'location' => $uri,
            'uri' => $uri
        ));
        $soap->setClass($this->get($class));

        // Response
        $response = new Response();
        $response->headers->set('Content-Type', 'text/xml; charset=ISO-8859-1');

        ob_start();
        // Handle Soap
        $soap->handle();
        $response->setContent(ob_get_clean());
        return $response;
    }
}
